/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.pentaho.reporting.designer.core.Messages;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.editor.ElementPropertiesPanel;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.editor.structuretree.AbstractReportTree;
import org.pentaho.reporting.designer.core.editor.structuretree.StructureTreePanel;

public class TreeSidePanel
extends JComponent {
    private ReportDesignerContext context;
    private ElementPropertiesPanel attributeEditorPanel;
    private StructureAndDataTabChangeHandler structureAndDataTabChangeHandler;
    private JTabbedPane tabs;

    public TreeSidePanel(ReportDesignerContext context, ElementPropertiesPanel attributeEditorPanel) {
        this.context = context;
        this.attributeEditorPanel = attributeEditorPanel;
        this.init();
    }

    private void init() {
        StructureTreePanel reportTree = new StructureTreePanel(AbstractReportTree.RenderType.REPORT);
        reportTree.setReportDesignerContext(this.context);
        JPanel structurePanel = new JPanel(new BorderLayout());
        JComponent structureToolBar = this.context.getToolBar("report-structure-toolbar");
        structurePanel.add((Component)structureToolBar, "North");
        structurePanel.add((Component)reportTree, "Center");
        JPanel dataPanel = new JPanel(new BorderLayout());
        JComponent dataToolBar = this.context.getToolBar("report-fields-toolbar");
        dataPanel.add((Component)dataToolBar, "North");
        StructureTreePanel dataTree = new StructureTreePanel(AbstractReportTree.RenderType.DATA);
        dataTree.setReportDesignerContext(this.context);
        dataPanel.add((Component)dataTree, "Center");
        this.tabs = new JTabbedPane(1);
        this.structureAndDataTabChangeHandler = new StructureAndDataTabChangeHandler();
        this.tabs.addChangeListener(this.structureAndDataTabChangeHandler);
        this.tabs.add(Messages.getString("StructureView.Structure", new Object[0]), structurePanel);
        this.tabs.add(Messages.getString("StructureView.Data", new Object[0]), dataPanel);
        this.setLayout(new BorderLayout());
        this.add((Component)this.tabs, "Center");
    }

    public void showDataTab() {
        this.tabs.setSelectedIndex(1);
    }

    public void refreshTabPanel(ElementPropertiesPanel attributeEditorPanel) {
        this.structureAndDataTabChangeHandler.refreshTabPanel(attributeEditorPanel, this.context.getActiveContext(), false, true, true);
    }

    protected ElementPropertiesPanel getAttributeEditorPanel() {
        return this.attributeEditorPanel;
    }

    private class StructureAndDataTabChangeHandler
    implements ChangeListener {
        private StructureAndDataTabChangeHandler() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            ElementPropertiesPanel attributeEditorPanel = TreeSidePanel.this.getAttributeEditorPanel();
            if (attributeEditorPanel == null) {
                return;
            }
            ReportDocumentContext activeContext = TreeSidePanel.this.context.getActiveContext();
            if (activeContext == null) {
                return;
            }
            JTabbedPane tabs = (JTabbedPane)e.getSource();
            if (tabs.getSelectedIndex() == 0) {
                this.refreshTabPanel(attributeEditorPanel, activeContext, true, false, false);
            } else {
                this.refreshTabPanel(attributeEditorPanel, activeContext, false, true, true);
            }
        }

        protected void refreshTabPanel(ElementPropertiesPanel attributeEditorPanel, ReportDocumentContext activeContext, boolean attributeCard, boolean datasourceCard, boolean expressionCard) {
            attributeEditorPanel.setAllowAttributeCard(attributeCard);
            attributeEditorPanel.setAllowDataSourceCard(datasourceCard);
            attributeEditorPanel.setAllowExpressionCard(expressionCard);
            attributeEditorPanel.reset(activeContext.getSelectionModel());
        }
    }
}

