/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.actions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.actions.AbstractDesignerContextAction;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.editor.ReportRenderContext;

public abstract class AbstractReportContextAction
extends AbstractDesignerContextAction {
    private ActiveContextChangeHandler changeHandler = new ActiveContextChangeHandler();

    protected AbstractReportContextAction() {
    }

    protected ReportDocumentContext getActiveContext() {
        if (this.getReportDesignerContext() == null) {
            return null;
        }
        return this.getReportDesignerContext().getActiveContext();
    }

    @Override
    protected void updateDesignerContext(ReportDesignerContext oldContext, ReportDesignerContext newContext) {
        if (oldContext != null) {
            oldContext.removePropertyChangeListener(this.changeHandler);
            ReportDocumentContext oldActiveContext = this.getActiveContext();
            this.updateActiveContext(oldActiveContext, null);
        }
        super.updateDesignerContext(oldContext, newContext);
        if (newContext != null) {
            newContext.addPropertyChangeListener("activeContext", this.changeHandler);
            this.updateActiveContext(null, newContext.getActiveContext());
        }
    }

    protected void updateActiveContext(ReportDocumentContext oldContext, ReportDocumentContext newContext) {
        this.setEnabled(newContext != null);
        ReportRenderContext oldCtx = null;
        ReportRenderContext newCtx = null;
        if (oldContext instanceof ReportRenderContext) {
            oldCtx = (ReportRenderContext)oldContext;
        }
        if (newContext instanceof ReportRenderContext) {
            newCtx = (ReportRenderContext)newContext;
        }
        this.updateActiveContext(oldCtx, newCtx);
    }

    protected void updateActiveContext(ReportRenderContext oldContext, ReportRenderContext newContext) {
        this.setEnabled(newContext != null);
    }

    private class ActiveContextChangeHandler
    implements PropertyChangeListener {
        private ActiveContextChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            ReportRenderContext oldContext = (ReportRenderContext)evt.getOldValue();
            ReportRenderContext activeContext = (ReportRenderContext)evt.getNewValue();
            AbstractReportContextAction.this.updateActiveContext(oldContext, activeContext);
        }
    }
}

