/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.actions.elements;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.actions.AbstractElementSelectionAction;
import org.pentaho.reporting.designer.core.actions.ActionMessages;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.editor.crosstab.CreateCrosstabDialog;
import org.pentaho.reporting.designer.core.editor.crosstab.CrosstabEditSupport;
import org.pentaho.reporting.designer.core.model.selection.DocumentContextSelectionModel;
import org.pentaho.reporting.designer.core.settings.SettingsListener;
import org.pentaho.reporting.designer.core.settings.WorkspaceSettings;
import org.pentaho.reporting.designer.core.util.IconLoader;
import org.pentaho.reporting.designer.core.util.exceptions.UncaughtExceptionsModel;
import org.pentaho.reporting.designer.core.util.undo.UndoEntry;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.CrosstabElement;
import org.pentaho.reporting.engine.classic.core.CrosstabGroup;
import org.pentaho.reporting.engine.classic.core.Group;
import org.pentaho.reporting.engine.classic.core.Section;
import org.pentaho.reporting.engine.classic.core.SubGroupBody;
import org.pentaho.reporting.engine.classic.core.event.ReportModelEvent;
import org.pentaho.reporting.engine.classic.core.filter.types.CrosstabElementType;
import org.pentaho.reporting.engine.classic.core.metadata.MetaData;
import org.pentaho.reporting.libraries.designtime.swing.LibSwingUtil;

public class EditCrosstabAction
extends AbstractElementSelectionAction
implements SettingsListener {
    private static final long serialVersionUID = 6766753579037904765L;

    public EditCrosstabAction() {
        this.putValue("Name", ActionMessages.getString("EditCrosstabAction.Text", new Object[0]));
        this.putValue("ShortDescription", ActionMessages.getString("EditCrosstabAction.Description", new Object[0]));
        this.putValue("MnemonicKey", ActionMessages.getOptionalMnemonic("EditCrosstabAction.Mnemonic"));
        this.putValue("AcceleratorKey", ActionMessages.getOptionalKeyStroke("EditCrosstabAction.Accelerator"));
        this.putValue("SmallIcon", IconLoader.getInstance().getGenericSquare());
        this.setVisible(WorkspaceSettings.getInstance().isVisible((MetaData)CrosstabElementType.INSTANCE.getMetaData()));
        WorkspaceSettings.getInstance().addSettingsListener(this);
    }

    @Override
    protected void selectedElementPropertiesChanged(ReportModelEvent event) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            ReportDocumentContext activeContext = this.getActiveContext();
            if (activeContext == null) {
                return;
            }
            CrosstabGroup selectedCrosstab = this.findSelectedCrosstab(activeContext);
            if (selectedCrosstab == null) {
                return;
            }
            CrosstabGroup newGroup = this.performEdit(selectedCrosstab);
            if (newGroup == null) {
                return;
            }
            UndoEntry undo = this.createUndoEntry(selectedCrosstab, newGroup);
            if (undo != null) {
                undo.redo(activeContext);
                activeContext.getUndo().addChange("Edit Crosstab", undo);
            }
        }
        catch (Exception ex) {
            UncaughtExceptionsModel.getInstance().addException(ex);
        }
    }

    protected CrosstabGroup performEdit(CrosstabGroup selectedCrosstab) {
        CreateCrosstabDialog dialog = this.createDialog();
        CrosstabGroup newGroup = dialog.createCrosstab(this.getReportDesignerContext(), selectedCrosstab);
        if (newGroup == null) {
            return null;
        }
        return newGroup;
    }

    protected UndoEntry createUndoEntry(CrosstabGroup selectedCrosstab, CrosstabGroup newGroup) {
        UndoEntry undo;
        Section parentSection = selectedCrosstab.getParentSection();
        if (parentSection instanceof AbstractReportDefinition) {
            AbstractReportDefinition r = (AbstractReportDefinition)parentSection;
            undo = new CrosstabEditSupport.EditGroupOnReportUndoEntry(r.getRootGroup(), (Group)newGroup);
        } else if (parentSection instanceof SubGroupBody) {
            SubGroupBody b = (SubGroupBody)parentSection;
            undo = new CrosstabEditSupport.EditGroupOnGroupUndoEntry(b.getObjectID(), b.getGroup(), (Group)newGroup);
        } else {
            undo = null;
        }
        return undo;
    }

    protected CrosstabGroup findSelectedCrosstab(ReportDocumentContext activeContext) {
        AbstractReportDefinition report = activeContext.getReportDefinition();
        Object selectedElement = null;
        if (report instanceof CrosstabElement) {
            selectedElement = this.findCrosstabGroup(report);
        } else if (this.getSelectionModel().getSelectionCount() > 0) {
            selectedElement = this.getSelectionModel().getSelectedElement(0);
        }
        if (!(selectedElement instanceof CrosstabGroup)) {
            return null;
        }
        return (CrosstabGroup)selectedElement;
    }

    protected CreateCrosstabDialog createDialog() {
        ReportDesignerContext context = this.getReportDesignerContext();
        Component parent = context.getView().getParent();
        Window window = LibSwingUtil.getWindowAncestor((Component)parent);
        CreateCrosstabDialog dialog = window instanceof JDialog ? new CreateCrosstabDialog((JDialog)window) : (window instanceof JFrame ? new CreateCrosstabDialog((JFrame)window) : new CreateCrosstabDialog());
        return dialog;
    }

    private Object findCrosstabGroup(AbstractReportDefinition report) {
        Group g = report.getRootGroup();
        while (g != null) {
            if (g instanceof CrosstabGroup) {
                return g;
            }
            g = g.getBody().getGroup();
        }
        return null;
    }

    @Override
    protected void updateSelection() {
        if (!this.isVisible()) {
            this.setEnabled(false);
            return;
        }
        ReportDocumentContext activeContext = this.getActiveContext();
        if (activeContext == null) {
            return;
        }
        AbstractReportDefinition reportDefinition = activeContext.getReportDefinition();
        if (reportDefinition instanceof CrosstabElement) {
            this.setEnabled(true);
            return;
        }
        DocumentContextSelectionModel selectionModel = this.getSelectionModel();
        if (selectionModel == null) {
            this.setEnabled(false);
            return;
        }
        if (!this.isSingleElementSelection()) {
            this.setEnabled(false);
            return;
        }
        Object selectedElement = selectionModel.getSelectedElement(0);
        if (selectedElement instanceof CrosstabGroup) {
            this.setEnabled(true);
            return;
        }
        this.setEnabled(false);
    }

    @Override
    public void settingsChanged() {
        this.setVisible(WorkspaceSettings.getInstance().isVisible((MetaData)CrosstabElementType.INSTANCE.getMetaData()));
    }
}

