/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.actions.elements;

import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.pentaho.reporting.designer.core.actions.AbstractElementSelectionAction;
import org.pentaho.reporting.designer.core.actions.ActionMessages;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.model.ModelUtility;
import org.pentaho.reporting.designer.core.model.selection.DocumentContextSelectionModel;
import org.pentaho.reporting.designer.core.util.IconLoader;
import org.pentaho.reporting.designer.core.util.dnd.ClipboardManager;
import org.pentaho.reporting.designer.core.util.exceptions.UncaughtExceptionsModel;
import org.pentaho.reporting.designer.core.util.undo.CompoundUndoEntry;
import org.pentaho.reporting.designer.core.util.undo.UndoEntry;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.ReportAttributeMap;
import org.pentaho.reporting.engine.classic.core.event.ReportModelEvent;
import org.pentaho.reporting.engine.classic.core.metadata.ElementMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.StyleMetaData;
import org.pentaho.reporting.engine.classic.core.style.BandStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleSheet;
import org.pentaho.reporting.engine.classic.core.style.StyleKey;
import org.pentaho.reporting.engine.classic.core.util.InstanceID;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public final class PasteFormatAction
extends AbstractElementSelectionAction
implements ChangeListener {
    private ClipboardStatus clipboardStatus;
    private boolean selectionActive;

    public PasteFormatAction() {
        this.putValue("SmallIcon", IconLoader.getInstance().getPasteIcon());
        this.putValue("Name", ActionMessages.getString("PasteFormatAction.Text", new Object[0]));
        this.putValue("ShortDescription", ActionMessages.getString("PasteFormatAction.Description", new Object[0]));
        this.putValue("MnemonicKey", ActionMessages.getOptionalMnemonic("PasteFormatAction.Mnemonic"));
        this.putValue("AcceleratorKey", ActionMessages.getOptionalKeyStroke("PasteFormatAction.Accelerator"));
        this.setEnabled(false);
        ClipboardManager.getManager().addChangeListener(this);
        this.stateChanged(null);
    }

    @Override
    protected void selectedElementPropertiesChanged(ReportModelEvent event) {
    }

    @Override
    protected void updateSelection() {
        ReportDocumentContext activeContext = this.getActiveContext();
        if (activeContext == null) {
            this.setSelectionActive(false);
            return;
        }
        Object rawLeadSelection = activeContext.getSelectionModel().getLeadSelection();
        if (rawLeadSelection == null) {
            this.setSelectionActive(false);
            return;
        }
        this.setSelectionActive(true);
    }

    public void setSelectionActive(boolean selectionActive) {
        this.selectionActive = selectionActive;
        if (selectionActive) {
            this.setEnabled(this.clipboardStatus == ClipboardStatus.GENERIC_ELEMENT);
        } else {
            this.setEnabled(false);
        }
    }

    public ClipboardStatus getClipboardStatus() {
        return this.clipboardStatus;
    }

    public void setClipboardStatus(ClipboardStatus clipboardStatus) {
        this.clipboardStatus = clipboardStatus;
        if (clipboardStatus != ClipboardStatus.GENERIC_ELEMENT) {
            this.setEnabled(false);
        } else {
            this.setEnabled(this.selectionActive);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (ClipboardManager.getManager().isDataAvailable()) {
            this.setClipboardStatus(ClipboardStatus.GENERIC_ELEMENT);
        } else {
            this.setClipboardStatus(ClipboardStatus.EMPTY);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ReportDocumentContext activeContext = this.getActiveContext();
        if (activeContext == null) {
            return;
        }
        DocumentContextSelectionModel selectionModel1 = this.getSelectionModel();
        if (selectionModel1 == null) {
            return;
        }
        List<Element> visualElements = selectionModel1.getSelectedElementsOfType(Element.class);
        if (visualElements.isEmpty()) {
            return;
        }
        if (!ClipboardManager.getManager().isDataAvailable()) {
            return;
        }
        try {
            Object[] data1 = ClipboardManager.getManager().getContents();
            if (data1.length == 0 || !(data1[0] instanceof Element)) {
                return;
            }
            Element data = (Element)data1[0];
            ElementStyleSheet styleSheet = data.getStyle();
            StyleKey[] definedPropertyNamesArray = styleSheet.getDefinedPropertyNamesArray();
            String elementType = data.getElementTypeName();
            Object formatString = data.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "format-string");
            ArrayList<PasteFormatUndoEntry> undos = new ArrayList<PasteFormatUndoEntry>();
            for (Element element : visualElements) {
                ElementMetaData metaData = element.getMetaData();
                ElementStyleSheet elementStyleSheet = element.getStyle();
                Object[] oldStyleData = new Object[StyleKey.getDefinedStyleKeyCount()];
                Object[] newStyleData = new Object[StyleKey.getDefinedStyleKeyCount()];
                for (int j = 0; j < definedPropertyNamesArray.length; ++j) {
                    Object newValue;
                    StyleMetaData styleDescr;
                    StyleKey styleKey = definedPropertyNamesArray[j];
                    if (styleKey == null || (styleDescr = metaData.getStyleDescription(styleKey)) == null || this.isFiltered(styleKey, styleDescr)) continue;
                    oldStyleData[styleKey.identifier] = elementStyleSheet.getStyleProperty(styleKey, null);
                    newStyleData[styleKey.identifier] = newValue = styleSheet.getStyleProperty(styleKey);
                    elementStyleSheet.setStyleProperty(styleKey, newValue);
                }
                ReportAttributeMap oldAttributes = new ReportAttributeMap();
                ReportAttributeMap newAttributes = new ReportAttributeMap();
                if (ObjectUtilities.equal((Object)elementType, (Object)element.getElementTypeName())) {
                    Object attribute = element.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "format-string");
                    oldAttributes.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "format-string", attribute);
                    newAttributes.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "format-string", formatString);
                    element.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "format-string", formatString);
                }
                PasteFormatUndoEntry undoEntry = new PasteFormatUndoEntry(element.getObjectID(), oldAttributes, newAttributes, oldStyleData, newStyleData);
                undos.add(undoEntry);
            }
            this.getActiveContext().getUndo().addChange(ActionMessages.getString("PasteFormatAction.UndoName", new Object[0]), new CompoundUndoEntry(undos.toArray(new UndoEntry[undos.size()])));
        }
        catch (UnsupportedFlavorException e1) {
            UncaughtExceptionsModel.getInstance().addException(e1);
        }
        catch (IOException e1) {
            UncaughtExceptionsModel.getInstance().addException(e1);
        }
    }

    private boolean isFiltered(StyleKey styleKey, StyleMetaData styleDescr) {
        if (styleDescr.isDeprecated()) {
            return true;
        }
        if (ElementStyleKeys.POS_X.equals((Object)styleKey)) {
            return true;
        }
        if (ElementStyleKeys.POS_Y.equals((Object)styleKey)) {
            return true;
        }
        if (ElementStyleKeys.MIN_WIDTH.equals((Object)styleKey)) {
            return true;
        }
        if (ElementStyleKeys.MIN_HEIGHT.equals((Object)styleKey)) {
            return true;
        }
        if (ElementStyleKeys.WIDTH.equals((Object)styleKey)) {
            return true;
        }
        if (ElementStyleKeys.HEIGHT.equals((Object)styleKey)) {
            return true;
        }
        if (ElementStyleKeys.MAX_WIDTH.equals((Object)styleKey)) {
            return true;
        }
        if (ElementStyleKeys.MAX_HEIGHT.equals((Object)styleKey)) {
            return true;
        }
        return BandStyleKeys.LAYOUT.equals((Object)styleKey);
    }

    private static enum ClipboardStatus {
        EMPTY,
        UNKNOWN,
        GENERIC_ELEMENT;

    }

    private static class PasteFormatUndoEntry
    implements UndoEntry {
        private InstanceID element;
        private ReportAttributeMap<Object> oldAttributes;
        private ReportAttributeMap<Object> newAttributes;
        private Object[] oldStyleData;
        private Object[] newStyleData;

        private PasteFormatUndoEntry(InstanceID element, ReportAttributeMap<Object> oldAttributes, ReportAttributeMap<Object> newAttributes, Object[] oldStyleData, Object[] newStyleData) {
            this.element = element;
            this.oldAttributes = oldAttributes.clone();
            this.newAttributes = newAttributes.clone();
            this.oldStyleData = (Object[])oldStyleData.clone();
            this.newStyleData = (Object[])newStyleData.clone();
        }

        @Override
        public void undo(ReportDocumentContext renderContext) {
            Element target = (Element)ModelUtility.findElementById(renderContext.getReportDefinition(), this.element);
            ElementStyleSheet styleSheet = target.getStyle();
            StyleKey[] keys = StyleKey.getDefinedStyleKeys();
            for (int i = 0; i < this.oldStyleData.length; ++i) {
                Object o = this.oldStyleData[i];
                if (o == null) continue;
                styleSheet.setStyleProperty(keys[i], o);
            }
            String[] namespaces = this.oldAttributes.getNameSpaces();
            for (int i = 0; i < namespaces.length; ++i) {
                String namespace = namespaces[i];
                String[] names = this.oldAttributes.getNames(namespace);
                for (int j = 0; j < names.length; ++j) {
                    String name = names[j];
                    target.setAttribute(namespace, name, this.oldAttributes.getAttribute(namespace, name), false);
                }
            }
            target.notifyNodePropertiesChanged();
        }

        @Override
        public void redo(ReportDocumentContext renderContext) {
            Element target = (Element)ModelUtility.findElementById(renderContext.getReportDefinition(), this.element);
            ElementStyleSheet styleSheet = target.getStyle();
            StyleKey[] keys = StyleKey.getDefinedStyleKeys();
            for (int i = 0; i < this.newStyleData.length; ++i) {
                Object o = this.newStyleData[i];
                if (o == null) continue;
                styleSheet.setStyleProperty(keys[i], o);
            }
            String[] namespaces = this.newAttributes.getNameSpaces();
            for (int i = 0; i < namespaces.length; ++i) {
                String namespace = namespaces[i];
                String[] names = this.newAttributes.getNames(namespace);
                for (int j = 0; j < names.length; ++j) {
                    String name = names[j];
                    target.setAttribute(namespace, name, this.newAttributes.getAttribute(namespace, name), false);
                }
            }
            target.notifyNodePropertiesChanged();
        }

        @Override
        public UndoEntry merge(UndoEntry newEntry) {
            return null;
        }
    }
}

