/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.actions.elements.distribute;

import java.awt.event.ActionEvent;
import java.awt.geom.Point2D;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.pentaho.reporting.designer.core.actions.AbstractElementSelectionAction;
import org.pentaho.reporting.designer.core.actions.ActionMessages;
import org.pentaho.reporting.designer.core.editor.report.drag.MoveDragOperation;
import org.pentaho.reporting.designer.core.editor.report.snapping.EmptySnapModel;
import org.pentaho.reporting.designer.core.model.CachedLayoutData;
import org.pentaho.reporting.designer.core.model.ModelUtility;
import org.pentaho.reporting.designer.core.model.selection.DocumentContextSelectionModel;
import org.pentaho.reporting.designer.core.util.IconLoader;
import org.pentaho.reporting.designer.core.util.undo.MassElementStyleUndoEntry;
import org.pentaho.reporting.designer.core.util.undo.MassElementStyleUndoEntryBuilder;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.event.ReportModelEvent;
import org.pentaho.reporting.engine.classic.core.util.geom.StrictGeomUtility;

public final class DistributeTopAction
extends AbstractElementSelectionAction {
    public DistributeTopAction() {
        this.putValue("Name", ActionMessages.getString("DistributeTopAction.Text", new Object[0]));
        this.putValue("ShortDescription", ActionMessages.getString("DistributeTopAction.Description", new Object[0]));
        this.putValue("MnemonicKey", ActionMessages.getOptionalMnemonic("DistributeTopAction.Mnemonic"));
        this.putValue("SmallIcon", IconLoader.getInstance().getDistributeTopIcon());
        this.putValue("AcceleratorKey", ActionMessages.getOptionalKeyStroke("DistributeTopAction.Accelerator"));
    }

    @Override
    protected void selectedElementPropertiesChanged(ReportModelEvent event) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        DocumentContextSelectionModel model = this.getSelectionModel();
        if (model == null) {
            return;
        }
        List<Element> visualElements = model.getSelectedElementsOfType(Element.class);
        if (visualElements.size() <= 2) {
            return;
        }
        List<Element> reportElements = ModelUtility.filterParents(visualElements);
        if (reportElements.size() <= 2) {
            return;
        }
        Collections.sort(reportElements, new ElementPositionComparator());
        MassElementStyleUndoEntryBuilder builder = new MassElementStyleUndoEntryBuilder(reportElements);
        Element[] carrier = new Element[1];
        int lastElementIdx = reportElements.size() - 1;
        Element lastElement = reportElements.get(lastElementIdx);
        Element firstElement = reportElements.get(0);
        CachedLayoutData firstLayoutData = ModelUtility.getCachedLayoutData(firstElement);
        CachedLayoutData lastLayoutData = ModelUtility.getCachedLayoutData(lastElement);
        long firstElementY = firstLayoutData.getY();
        long height = lastLayoutData.getY() - firstElementY;
        long incr = height / (long)lastElementIdx;
        long currentY = firstElementY;
        currentY += incr;
        for (Element reportElement : reportElements) {
            CachedLayoutData layoutData = ModelUtility.getCachedLayoutData(reportElement);
            carrier[0] = reportElement;
            Point2D.Double originPoint = new Point2D.Double(0.0, StrictGeomUtility.toExternalValue((long)layoutData.getY()));
            MoveDragOperation mop = new MoveDragOperation(Arrays.asList(carrier), originPoint, EmptySnapModel.INSTANCE, EmptySnapModel.INSTANCE);
            mop.update(new Point2D.Double(0.0, StrictGeomUtility.toExternalValue((long)currentY)), 1.0);
            mop.finish();
            currentY += incr;
        }
        MassElementStyleUndoEntry massElementStyleUndoEntry = builder.finish();
        this.getActiveContext().getUndo().addChange(ActionMessages.getString("DistributeTopAction.UndoName", new Object[0]), massElementStyleUndoEntry);
    }

    private static class ElementPositionComparator
    implements Comparator<Element> {
        private ElementPositionComparator() {
        }

        @Override
        public int compare(Element o1, Element o2) {
            CachedLayoutData data2;
            long x2;
            CachedLayoutData data1 = ModelUtility.getCachedLayoutData(o1);
            long x1 = data1.getY();
            if (x1 < (x2 = (data2 = ModelUtility.getCachedLayoutData(o2)).getY())) {
                return -1;
            }
            if (x1 > x2) {
                return 1;
            }
            return 0;
        }
    }
}

