/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.actions.elements.format;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;
import org.pentaho.reporting.designer.core.actions.AbstractElementSelectionAction;
import org.pentaho.reporting.designer.core.actions.ActionMessages;
import org.pentaho.reporting.designer.core.model.selection.DocumentContextSelectionModel;
import org.pentaho.reporting.designer.core.util.undo.CompoundUndoEntry;
import org.pentaho.reporting.designer.core.util.undo.StyleEditUndoEntry;
import org.pentaho.reporting.designer.core.util.undo.UndoEntry;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.event.ReportModelEvent;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleSheet;
import org.pentaho.reporting.engine.classic.core.style.TextStyleKeys;

public final class ApplyFontSizeAction
extends AbstractElementSelectionAction {
    private JComboBox comboBox;

    public ApplyFontSizeAction(JComboBox comboBox) {
        this.comboBox = comboBox;
        this.putValue("Name", ActionMessages.getString("ApplyFontSizeAction.Text", new Object[0]));
        this.putValue("ShortDescription", ActionMessages.getString("ApplyFontSizeAction.Description", new Object[0]));
        this.putValue("MnemonicKey", ActionMessages.getOptionalMnemonic("ApplyFontSizeAction.Mnemonic"));
        this.putValue("AcceleratorKey", ActionMessages.getOptionalKeyStroke("ApplyFontSizeAction.Accelerator"));
    }

    @Override
    protected void selectedElementPropertiesChanged(ReportModelEvent event) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = this.comboBox.getSelectedItem();
        if (!(o instanceof Integer)) {
            return;
        }
        Integer fontSize = (Integer)o;
        DocumentContextSelectionModel model = this.getSelectionModel();
        if (model == null) {
            return;
        }
        List<Element> visualElements = model.getSelectedElementsOfType(Element.class);
        ArrayList<StyleEditUndoEntry> undos = new ArrayList<StyleEditUndoEntry>();
        for (Element visualElement : visualElements) {
            ElementStyleSheet styleSheet = visualElement.getStyle();
            undos.add(StyleEditUndoEntry.createConditional((ReportElement)visualElement, TextStyleKeys.FONTSIZE, fontSize));
            styleSheet.setStyleProperty(TextStyleKeys.FONTSIZE, (Object)fontSize);
            visualElement.notifyNodePropertiesChanged();
        }
        this.getActiveContext().getUndo().addChange(ActionMessages.getString("ApplyFontSizeAction.UndoName", new Object[0]), new CompoundUndoEntry(undos.toArray(new UndoEntry[undos.size()])));
    }
}

