/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.actions.elements.format;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.Map;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.pentaho.reporting.designer.core.actions.AbstractElementSelectionAction;
import org.pentaho.reporting.designer.core.actions.ActionMessages;
import org.pentaho.reporting.designer.core.editor.format.EditableStyleSheet;
import org.pentaho.reporting.designer.core.editor.format.ElementFormatDialog;
import org.pentaho.reporting.designer.core.model.selection.DocumentContextSelectionModel;
import org.pentaho.reporting.designer.core.util.undo.ElementFormatUndoEntry;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.event.ReportModelEvent;
import org.pentaho.reporting.libraries.designtime.swing.LibSwingUtil;

public class ElementFormatAction
extends AbstractElementSelectionAction {
    public ElementFormatAction() {
        this.putValue("Name", ActionMessages.getString("ElementFormatAction.Text", new Object[0]));
        this.putValue("ShortDescription", ActionMessages.getString("ElementFormatAction.Description", new Object[0]));
        this.putValue("MnemonicKey", ActionMessages.getOptionalMnemonic("ElementFormatAction.Mnemonic"));
        this.putValue("AcceleratorKey", ActionMessages.getOptionalKeyStroke("ElementFormatAction.Accelerator"));
    }

    @Override
    protected void selectedElementPropertiesChanged(ReportModelEvent event) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        DocumentContextSelectionModel model = this.getSelectionModel();
        if (model == null) {
            return;
        }
        List<Element> visualElements = model.getSelectedElementsOfType(Element.class);
        EditableStyleSheet styleSheet = EditableStyleSheet.create(visualElements);
        Map styleExpressions = visualElements.isEmpty() ? null : visualElements.get(0).getStyleExpressions();
        Component parent = this.getReportDesignerContext().getView().getParent();
        Window window = LibSwingUtil.getWindowAncestor((Component)parent);
        ElementFormatDialog dialog = this.createDialog(window);
        ElementFormatUndoEntry.EditResult result = dialog.performEdit(this.getReportDesignerContext(), styleSheet, styleExpressions);
        if (result == null) {
            return;
        }
        ElementFormatUndoEntry undoEntry = result.process(visualElements);
        this.getActiveContext().getUndo().addChange(ActionMessages.getString("ElementFormatAction.UndoName", new Object[0]), undoEntry);
    }

    protected ElementFormatDialog createDialog(Window window) {
        ElementFormatDialog dialog = window instanceof JDialog ? new ElementFormatDialog((JDialog)window) : (window instanceof JFrame ? new ElementFormatDialog((JFrame)window) : new ElementFormatDialog());
        return dialog;
    }
}

