/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.actions.elements.format;

import java.awt.Color;
import java.awt.Dimension;
import java.util.List;
import javax.swing.JComboBox;
import org.pentaho.reporting.designer.core.DesignerContextComponent;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.actions.ElementSelectionComponentSupport;
import org.pentaho.reporting.designer.core.actions.elements.format.ApplyFontColorAction;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.event.ReportModelEvent;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.designtime.swing.ColorComboBox;

public final class FontColorSelectorComponent
extends ColorComboBox
implements DesignerContextComponent {
    private ApplyFontColorAction applyFontColorAction = new ApplyFontColorAction((JComboBox)((Object)this));
    private SelectionUpdateHelper updateHelper = new SelectionUpdateHelper();

    public FontColorSelectorComponent() {
        int height1 = this.getPreferredSize().height;
        this.setMaximumSize(new Dimension(height1 * 4, height1));
        this.setFocusable(false);
        this.setAction(this.applyFontColorAction);
    }

    @Override
    public void setReportDesignerContext(ReportDesignerContext context) {
        this.applyFontColorAction.setReportDesignerContext(context);
        this.updateHelper.setReportDesignerContext(context);
    }

    @Override
    public ReportDesignerContext getReportDesignerContext() {
        return this.applyFontColorAction.getReportDesignerContext();
    }

    private class SelectionUpdateHelper
    extends ElementSelectionComponentSupport {
        private Element lastSelection;

        private SelectionUpdateHelper() {
        }

        @Override
        protected void updateSelection() {
            if (this.getSelectionModel() == null) {
                FontColorSelectorComponent.this.setEnabled(false);
                FontColorSelectorComponent.this.setValueFromModel(null);
                this.lastSelection = null;
            } else {
                List<Element> visualElements = this.getSelectionModel().getSelectedElementsOfType(Element.class);
                if (visualElements.isEmpty()) {
                    FontColorSelectorComponent.this.setEnabled(false);
                    FontColorSelectorComponent.this.setValueFromModel(null);
                    this.lastSelection = null;
                } else {
                    this.lastSelection = visualElements.get(0);
                    FontColorSelectorComponent.this.setEnabled(true);
                    Color color = (Color)this.lastSelection.getStyle().getStyleProperty(ElementStyleKeys.PAINT);
                    for (int i = 1; i < visualElements.size(); ++i) {
                        Element element = visualElements.get(i);
                        Object otherColor = element.getStyle().getStyleProperty(ElementStyleKeys.PAINT);
                        if (ObjectUtilities.equal((Object)color, (Object)otherColor)) continue;
                        FontColorSelectorComponent.this.setValueFromModel(null);
                        return;
                    }
                    FontColorSelectorComponent.this.setValueFromModel(color);
                }
            }
        }

        @Override
        protected void nodeChanged(ReportModelEvent event) {
            if (event.getElement() == this.lastSelection) {
                Color color = (Color)this.lastSelection.getStyle().getStyleProperty(ElementStyleKeys.PAINT);
                FontColorSelectorComponent.this.setValueFromModel(color);
            }
        }
    }
}

