/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.actions.elements.format;

import java.awt.Dimension;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import org.pentaho.reporting.designer.core.DesignerContextComponent;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.actions.ElementSelectionComponentSupport;
import org.pentaho.reporting.designer.core.actions.elements.format.ApplyFontSizeAction;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.event.ReportModelEvent;
import org.pentaho.reporting.engine.classic.core.style.TextStyleKeys;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.designtime.swing.SmartComboBox;

public final class FontSizeSelectorComponent
extends SmartComboBox
implements DesignerContextComponent {
    private ApplyFontSizeAction applyFontSizeAction = new ApplyFontSizeAction((JComboBox)((Object)this));
    private SelectionUpdateHelper updateHelper = new SelectionUpdateHelper();

    public FontSizeSelectorComponent() {
        Integer[] fontSizes = new Integer[]{6, 8, 10, 12, 14, 16, 18, 20, 24, 28, 32, 36, 48, 72};
        this.setModel(new DefaultComboBoxModel<Integer>(fontSizes));
        this.setFocusable(false);
        int height1 = this.getPreferredSize().height;
        this.setMaximumSize(new Dimension(height1 * 3, height1));
        this.setAction(this.applyFontSizeAction);
    }

    @Override
    public void setReportDesignerContext(ReportDesignerContext context) {
        this.applyFontSizeAction.setReportDesignerContext(context);
        this.updateHelper.setReportDesignerContext(context);
    }

    @Override
    public ReportDesignerContext getReportDesignerContext() {
        return this.applyFontSizeAction.getReportDesignerContext();
    }

    protected void setValueFromModel(Object o) {
        this.setAction(null);
        this.setSelectedItem(o);
        this.setAction(this.applyFontSizeAction);
    }

    private class SelectionUpdateHelper
    extends ElementSelectionComponentSupport {
        private Element lastSelection;

        private SelectionUpdateHelper() {
        }

        @Override
        protected void updateSelection() {
            if (this.getSelectionModel() == null) {
                FontSizeSelectorComponent.this.setEnabled(false);
                FontSizeSelectorComponent.this.setValueFromModel(null);
                this.lastSelection = null;
            } else {
                List<Element> visualElements = this.getSelectionModel().getSelectedElementsOfType(Element.class);
                if (visualElements.isEmpty()) {
                    FontSizeSelectorComponent.this.setValueFromModel(null);
                    FontSizeSelectorComponent.this.setEnabled(false);
                    this.lastSelection = null;
                } else {
                    this.lastSelection = visualElements.get(0);
                    Object color = this.lastSelection.getStyle().getStyleProperty(TextStyleKeys.FONTSIZE);
                    for (int i = 1; i < visualElements.size(); ++i) {
                        Element element = visualElements.get(i);
                        Object otherColor = element.getStyle().getStyleProperty(TextStyleKeys.FONTSIZE);
                        if (ObjectUtilities.equal((Object)color, (Object)otherColor)) continue;
                        FontSizeSelectorComponent.this.setEnabled(true);
                        FontSizeSelectorComponent.this.setValueFromModel(null);
                        return;
                    }
                    FontSizeSelectorComponent.this.setEnabled(true);
                    FontSizeSelectorComponent.this.setValueFromModel(color);
                }
            }
        }

        @Override
        protected void nodeChanged(ReportModelEvent event) {
            if (event.getElement() == this.lastSelection) {
                Object color = this.lastSelection.getStyle().getStyleProperty(TextStyleKeys.FONTSIZE);
                FontSizeSelectorComponent.this.setValueFromModel(color);
            }
        }
    }
}

