/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.actions.global;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.actions.AbstractReportContextAction;
import org.pentaho.reporting.designer.core.editor.ReportRenderContext;

public abstract class AbstractViewStateAction
extends AbstractReportContextAction {
    private ViewStateChangeHandler changeHandler = new ViewStateChangeHandler();

    protected AbstractViewStateAction() {
    }

    @Override
    protected void updateDesignerContext(ReportDesignerContext oldContext, ReportDesignerContext newContext) {
        if (oldContext != null) {
            oldContext.getView().removePropertyChangeListener("reportDesignerViewState", this.changeHandler);
        }
        super.updateDesignerContext(oldContext, newContext);
        if (newContext != null) {
            newContext.getView().addPropertyChangeListener("reportDesignerViewState", this.changeHandler);
        }
    }

    @Override
    protected void updateActiveContext(ReportRenderContext oldContext, ReportRenderContext newContext) {
        super.updateActiveContext(oldContext, newContext);
        if (this.getReportDesignerContext() == null) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled(this.recomputeEnabled());
    }

    protected abstract boolean recomputeEnabled();

    private class ViewStateChangeHandler
    implements PropertyChangeListener {
        private ViewStateChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            AbstractViewStateAction.this.setEnabled(AbstractViewStateAction.this.recomputeEnabled());
        }
    }
}

