/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.actions.global;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import org.pentaho.reporting.designer.core.actions.AbstractElementSelectionAction;
import org.pentaho.reporting.designer.core.actions.ActionMessages;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.model.selection.DocumentContextSelectionModel;
import org.pentaho.reporting.designer.core.util.IconLoader;
import org.pentaho.reporting.designer.core.util.dnd.InsertationUtil;
import org.pentaho.reporting.designer.core.util.undo.CompoundUndoEntry;
import org.pentaho.reporting.designer.core.util.undo.UndoEntry;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.Group;
import org.pentaho.reporting.engine.classic.core.GroupBody;
import org.pentaho.reporting.engine.classic.core.ReportDefinition;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.Section;
import org.pentaho.reporting.engine.classic.core.event.ReportModelEvent;
import org.pentaho.reporting.engine.classic.core.parameters.ParameterDefinitionEntry;

public final class DeleteAction
extends AbstractElementSelectionAction {
    public DeleteAction() {
        this.putValue("Name", ActionMessages.getString("DeleteAction.Text", new Object[0]));
        this.putValue("ShortDescription", ActionMessages.getString("DeleteAction.Description", new Object[0]));
        this.putValue("MnemonicKey", ActionMessages.getOptionalMnemonic("DeleteAction.Mnemonic"));
        this.putValue("SmallIcon", IconLoader.getInstance().getDeleteIconSmall());
        this.putValue("AcceleratorKey", ActionMessages.getOptionalKeyStroke("DeleteAction.Accelerator"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ReportDocumentContext activeContext = this.getActiveContext();
        if (activeContext == null) {
            return;
        }
        DocumentContextSelectionModel selectionModel = activeContext.getSelectionModel();
        Object[] selectedElements = selectionModel.getSelectedElements();
        if (this.isParameter()) {
            String theTitle = ActionMessages.getString("DeleteAction.Warning", new Object[0]);
            String theDeleteMessage = ActionMessages.getString("DeleteAction.Confirmation", new Object[0]);
            Component theParent = this.getReportDesignerContext().getView().getParent();
            int result = JOptionPane.showConfirmDialog(theParent, theDeleteMessage, theTitle, 0);
            if (result != 0) {
                return;
            }
        }
        ArrayList<UndoEntry> undos = new ArrayList<UndoEntry>();
        for (int i = 0; i < selectedElements.length; ++i) {
            Object element = selectedElements[i];
            UndoEntry undoEntry = InsertationUtil.delete(activeContext, element);
            if (undoEntry == null) continue;
            undos.add(undoEntry);
        }
        if (!undos.isEmpty()) {
            activeContext.getUndo().addChange(ActionMessages.getString("DeleteAction.Text", new Object[0]), new CompoundUndoEntry(undos.toArray(new UndoEntry[undos.size()])));
        }
    }

    private boolean isParameter() {
        DocumentContextSelectionModel selectionModel = this.getActiveContext().getSelectionModel();
        Object[] selectedElements = selectionModel.getSelectedElements();
        for (int i = 0; i < selectedElements.length; ++i) {
            if (!(selectedElements[i] instanceof ParameterDefinitionEntry)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void selectedElementPropertiesChanged(ReportModelEvent event) {
    }

    @Override
    protected void updateSelection() {
        DocumentContextSelectionModel selectionModel1 = this.getSelectionModel();
        if (selectionModel1 == null || selectionModel1.getSelectionCount() == 0) {
            this.setEnabled(false);
            return;
        }
        Object[] selectedElements = selectionModel1.getSelectedElements();
        for (int i = 0; i < selectedElements.length; ++i) {
            Object selectedElement = selectedElements[i];
            if (selectedElement instanceof AbstractReportDefinition) {
                if (this.getActiveContext().getReportDefinition() != selectedElement) continue;
                this.setEnabled(false);
                return;
            }
            if (!(selectedElement instanceof ReportElement)) continue;
            Section parent = ((ReportElement)selectedElement).getParentSection();
            if (parent instanceof ReportDefinition) {
                this.setEnabled(false);
                return;
            }
            if (!(parent instanceof Group) && !(parent instanceof GroupBody)) continue;
            this.setEnabled(false);
            return;
        }
        this.setEnabled(true);
    }
}

