/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.actions.global;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.io.IOException;
import org.pentaho.reporting.designer.core.actions.AbstractDesignerContextAction;
import org.pentaho.reporting.designer.core.actions.ActionMessages;
import org.pentaho.reporting.designer.core.util.ExternalToolLauncher;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.ExceptionDialog;

public final class ReportABugAction
extends AbstractDesignerContextAction {
    public ReportABugAction() {
        this.putValue("Name", ActionMessages.getString("ReportABugAction.Text", new Object[0]));
        this.putValue("ShortDescription", ActionMessages.getString("ReportABugAction.Description", new Object[0]));
        this.putValue("MnemonicKey", ActionMessages.getOptionalMnemonic("ReportABugAction.Mnemonic"));
        this.putValue("AcceleratorKey", ActionMessages.getOptionalKeyStroke("ReportABugAction.Accelerator"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Thread t = new Thread(new LaunchBrowserTask(this.getReportDesignerContext().getView().getParent()));
        t.setDaemon(true);
        t.start();
    }

    private static class ShowErrorMessageTask
    implements Runnable {
        private Component parent;
        private Exception exception;

        private ShowErrorMessageTask(Component parent, Exception exception) {
            this.parent = parent;
            this.exception = exception;
        }

        @Override
        public void run() {
            ExceptionDialog.showExceptionDialog((Component)this.parent, (String)ActionMessages.getString("ReportABugAction.Error.Title", new Object[0]), (String)ActionMessages.getString("ReportABugAction.Error.Message", new Object[0]), (Exception)this.exception);
        }
    }

    private static class LaunchBrowserTask
    implements Runnable {
        private Component parent;

        private LaunchBrowserTask(Component parent) {
            this.parent = parent;
        }

        @Override
        public void run() {
            try {
                String url = ActionMessages.getString("ReportABugAction.URL", new Object[0]);
                ExternalToolLauncher.openURL(url);
            }
            catch (IOException e) {
                EventQueue.invokeLater(new ShowErrorMessageTask(this.parent, e));
            }
        }
    }
}

