/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.actions.global;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.actions.AbstractDesignerContextAction;
import org.pentaho.reporting.designer.core.actions.ActionMessages;
import org.pentaho.reporting.designer.core.actions.ToggleStateAction;
import org.pentaho.reporting.designer.core.util.IconLoader;

public final class ShowPreviewPaneAction
extends AbstractDesignerContextAction
implements ToggleStateAction {
    private PreviewSelectionUpdateListener selectionUpdateListener = new PreviewSelectionUpdateListener();

    public ShowPreviewPaneAction() {
        this.putValue("SwingSelectedKey", Boolean.FALSE);
        this.putValue("Name", ActionMessages.getString("ShowPreviewPaneAction.Text", new Object[0]));
        this.putValue("ShortDescription", ActionMessages.getString("ShowPreviewPaneAction.Description", new Object[0]));
        this.putValue("MnemonicKey", ActionMessages.getOptionalMnemonic("ShowPreviewPaneAction.Mnemonic"));
        this.putValue("AcceleratorKey", ActionMessages.getOptionalKeyStroke("ShowPreviewPaneAction.Accelerator"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ReportDesignerContext reportDesignerContext = this.getReportDesignerContext();
        if (reportDesignerContext == null) {
            return;
        }
        reportDesignerContext.getView().setPreviewVisible(!reportDesignerContext.getView().isPreviewVisible());
    }

    protected String getPropertyName() {
        return "previewVisible";
    }

    protected boolean recomputeEnabled() {
        ReportDesignerContext reportDesignerContext = this.getReportDesignerContext();
        if (reportDesignerContext == null) {
            this.setSelected(false);
            return false;
        }
        this.setSelected(reportDesignerContext.getView().isPreviewVisible());
        return true;
    }

    public void setSelected(boolean selected) {
        this.putValue("SwingSelectedKey", selected);
        if (!selected) {
            this.putValue("ShortDescription", ActionMessages.getString("ShowPreviewPaneAction.Text", new Object[0]));
            this.putValue("SmallIcon", IconLoader.getInstance().getPreviewIcon());
        } else {
            this.putValue("ShortDescription", ActionMessages.getString("ShowEditorPaneAction.Text", new Object[0]));
            this.putValue("SmallIcon", IconLoader.getInstance().getEditIcon());
        }
    }

    @Override
    protected void updateDesignerContext(ReportDesignerContext oldContext, ReportDesignerContext newContext) {
        if (oldContext != null) {
            oldContext.getView().removePropertyChangeListener("previewVisible", this.selectionUpdateListener);
            oldContext.removePropertyChangeListener("activeContext", this.selectionUpdateListener);
        }
        super.updateDesignerContext(oldContext, newContext);
        if (newContext != null) {
            newContext.getView().addPropertyChangeListener("previewVisible", this.selectionUpdateListener);
            newContext.addPropertyChangeListener("activeContext", this.selectionUpdateListener);
        }
        this.recomputeEnabled();
    }

    @Override
    public boolean isSelected() {
        return Boolean.TRUE.equals(this.getValue("SwingSelectedKey"));
    }

    private class PreviewSelectionUpdateListener
    implements PropertyChangeListener {
        private PreviewSelectionUpdateListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            ShowPreviewPaneAction.this.recomputeEnabled();
        }
    }
}

