/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.actions.global;

import java.awt.event.ActionEvent;
import org.pentaho.reporting.designer.core.actions.AbstractReportContextAction;
import org.pentaho.reporting.designer.core.actions.ActionMessages;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.editor.ZoomModel;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.internal.PreviewPaneUtilities;

public class ZoomOutAction
extends AbstractReportContextAction {
    private static double[] ZOOM_FACTORS = new double[]{0.5, 0.75, 1.0, 1.25, 1.5, 2.0, 4.0};

    public ZoomOutAction() {
        this.putValue("Name", ActionMessages.getString("ZoomOutAction.Text", new Object[0]));
        this.putValue("ShortDescription", ActionMessages.getString("ZoomOutAction.Description", new Object[0]));
        this.putValue("MnemonicKey", ActionMessages.getOptionalMnemonic("ZoomOutAction.Mnemonic"));
        this.putValue("AcceleratorKey", ActionMessages.getOptionalKeyStroke("ZoomOutAction.Accelerator"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ReportDocumentContext activeContext = this.getActiveContext();
        if (activeContext == null) {
            return;
        }
        ZoomModel zoomModel = activeContext.getZoomModel();
        double nextZoomIn = PreviewPaneUtilities.getNextZoomOut((double)zoomModel.getZoomAsPercentage(), (double[])ZOOM_FACTORS);
        if (nextZoomIn == 0.0) {
            return;
        }
        zoomModel.setZoomAsPercentage((float)nextZoomIn);
    }
}

