/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.actions.report;

import java.awt.Cursor;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.Locale;
import javax.swing.table.TableModel;
import org.pentaho.reporting.designer.core.actions.AbstractReportContextAction;
import org.pentaho.reporting.designer.core.actions.ActionMessages;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.util.ReportDesignerDesignTimeContext;
import org.pentaho.reporting.designer.core.util.exceptions.UncaughtExceptionsModel;
import org.pentaho.reporting.designer.core.util.undo.AttributeEditUndoEntry;
import org.pentaho.reporting.designer.core.util.undo.DataSourceEditUndoEntry;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.CompoundDataFactory;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.designtime.DataFactoryChange;
import org.pentaho.reporting.engine.classic.core.designtime.DataFactoryChangeRecorder;
import org.pentaho.reporting.engine.classic.core.designtime.DataSourcePlugin;
import org.pentaho.reporting.engine.classic.core.designtime.DefaultDataFactoryChangeRecorder;
import org.pentaho.reporting.engine.classic.core.designtime.DesignTimeContext;
import org.pentaho.reporting.engine.classic.core.metadata.DataFactoryMetaData;
import org.pentaho.reporting.engine.classic.core.wizard.ContextAwareDataSchemaModel;
import org.pentaho.reporting.libraries.base.util.StringUtils;

public class AddDataFactoryAction
extends AbstractReportContextAction {
    private DataFactoryMetaData dataSourcePlugin;

    public AddDataFactoryAction(DataFactoryMetaData dataSourcePlugin) {
        this.dataSourcePlugin = dataSourcePlugin;
        this.putValue("Name", dataSourcePlugin.getDisplayName(Locale.getDefault()));
        this.putValue("ShortDescription", dataSourcePlugin.getDescription(Locale.getDefault()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        ReportDocumentContext activeContext = this.getActiveContext();
        if (activeContext == null) {
            return;
        }
        DataSourcePlugin editor = this.dataSourcePlugin.createEditor();
        if (editor == null) {
            return;
        }
        DefaultDataFactoryChangeRecorder recorder = new DefaultDataFactoryChangeRecorder();
        ReportDesignerDesignTimeContext designTimeContext = new ReportDesignerDesignTimeContext(this.getReportDesignerContext());
        DataFactory dataFactory = editor.performEdit((DesignTimeContext)designTimeContext, null, null, (DataFactoryChangeRecorder)recorder);
        if (dataFactory == null) {
            return;
        }
        Window parentWindow = designTimeContext.getParentWindow();
        try {
            parentWindow.setCursor(Cursor.getPredefinedCursor(3));
            AddDataFactoryAction.addDataFactory(activeContext, dataFactory, recorder.getChanges());
        }
        finally {
            ContextAwareDataSchemaModel dataSchemaModel = activeContext.getReportDataSchemaModel();
            if (dataSchemaModel.getDataFactoryException() != null) {
                UncaughtExceptionsModel.getInstance().addException(dataSchemaModel.getDataFactoryException());
            }
            parentWindow.setCursor(Cursor.getDefaultCursor());
        }
    }

    public static void addDataFactory(ReportDocumentContext activeContext, DataFactory dataFactory, DataFactoryChange[] dataFactoryChanges) {
        if (dataFactory == null) {
            throw new NullPointerException();
        }
        AbstractReportDefinition report = activeContext.getReportDefinition();
        DataFactory originalDataFactory = report.getDataFactory();
        if (originalDataFactory == null) {
            throw new IllegalStateException("A report in design-mode should have its data-factory normalized.");
        }
        String queryAttribute = (String)report.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/internal", "query");
        if (StringUtils.isEmpty((String)queryAttribute) && dataFactory.getQueryNames().length > 0) {
            String queryName = dataFactory.getQueryNames()[0];
            report.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/internal", "query", (Object)queryName);
            activeContext.getUndo().addChange(ActionMessages.getString("AddDataFactoryAction.SetQuery.UndoText", new Object[0]), new AttributeEditUndoEntry(report.getObjectID(), "http://reporting.pentaho.org/namespaces/engine/attributes/internal", "query", queryAttribute, queryName));
        }
        if (AddDataFactoryAction.isLegacyDefaultDataFactory(originalDataFactory)) {
            CompoundDataFactory compoundDataFactory = CompoundDataFactory.normalize((DataFactory)dataFactory);
            DefaultDataFactoryChangeRecorder.applyChanges((CompoundDataFactory)compoundDataFactory, (DataFactoryChange[])dataFactoryChanges);
            report.setDataFactory((DataFactory)compoundDataFactory);
            activeContext.getUndo().addChange(ActionMessages.getString("AddDataFactoryAction.UndoText", new Object[0]), new DataSourceEditUndoEntry(0, null, dataFactory.derive()));
        } else {
            CompoundDataFactory reportDf = CompoundDataFactory.normalize((DataFactory)originalDataFactory);
            DefaultDataFactoryChangeRecorder.applyChanges((CompoundDataFactory)reportDf, (DataFactoryChange[])dataFactoryChanges);
            int position = reportDf.size();
            reportDf.add(dataFactory);
            activeContext.getUndo().addChange(ActionMessages.getString("AddDataFactoryAction.UndoText", new Object[0]), new DataSourceEditUndoEntry(position, null, dataFactory.derive()));
            report.setDataFactory((DataFactory)reportDf);
        }
    }

    private static boolean isLegacyDefaultDataFactory(DataFactory dataFactory) {
        String[] queryNames = dataFactory.getQueryNames();
        if (queryNames.length == 0) {
            return true;
        }
        if (queryNames.length != 1) {
            return false;
        }
        if ("default".equals(queryNames[0])) {
            try {
                TableModel tableModel = dataFactory.queryData("default", null);
                if (tableModel.getRowCount() == 0 && tableModel.getColumnCount() == 0) {
                    return true;
                }
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }
}

