/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.actions.report;

import java.awt.event.ActionEvent;
import org.pentaho.reporting.designer.core.actions.AbstractReportContextAction;
import org.pentaho.reporting.designer.core.actions.ActionMessages;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.model.CachedLayoutData;
import org.pentaho.reporting.designer.core.model.ModelUtility;
import org.pentaho.reporting.designer.core.util.IconLoader;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.RootLevelBand;
import org.pentaho.reporting.engine.classic.core.Section;
import org.pentaho.reporting.engine.classic.core.SubReport;
import org.pentaho.reporting.engine.classic.core.util.geom.StrictGeomUtility;

public final class AdjustBandSizeAction
extends AbstractReportContextAction {
    public AdjustBandSizeAction() {
        this.putValue("SmallIcon", IconLoader.getInstance().getLayoutBandsIcon());
        this.putValue("Name", ActionMessages.getString("AdjustBandSizeAction.Text", new Object[0]));
        this.putValue("Default", ActionMessages.getString("AdjustBandSizeAction.Description", new Object[0]));
        this.putValue("MnemonicKey", ActionMessages.getOptionalMnemonic("AdjustBandSizeAction.Mnemonic"));
        this.putValue("AcceleratorKey", ActionMessages.getOptionalKeyStroke("AdjustBandSizeAction.Accelerator"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ReportDocumentContext activeContext = this.getActiveContext();
        if (activeContext == null) {
            return;
        }
        AbstractReportDefinition definition = activeContext.getReportDefinition();
        this.iterateSection((Section)definition);
        this.getReportDesignerContext().getView().redrawAll();
    }

    private void iterateSection(Section s) {
        int elementCount = s.getElementCount();
        for (int i = 0; i < elementCount; ++i) {
            Element e = s.getElement(i);
            if (e instanceof SubReport) continue;
            if (e instanceof RootLevelBand) {
                CachedLayoutData layoutData = ModelUtility.getCachedLayoutData(e);
                double height = StrictGeomUtility.toExternalValue((long)layoutData.getHeight());
                e.setAttribute("http://reporting.pentaho.org/namespaces/report-designer/2.0", "visual-height", (Object)new Double(height));
            }
            if (!(e instanceof Section)) continue;
            this.iterateSection((Section)e);
        }
    }
}

