/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.actions.report;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.Enumeration;
import java.util.HashMap;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.pentaho.reporting.designer.core.actions.AbstractReportContextAction;
import org.pentaho.reporting.designer.core.actions.ActionMessages;
import org.pentaho.reporting.designer.core.editor.ConfigurationEditorDialog;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.util.undo.EditReportConfigUndoEntry;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.libraries.base.config.HierarchicalConfiguration;
import org.pentaho.reporting.libraries.base.config.ModifiableConfiguration;
import org.pentaho.reporting.libraries.designtime.swing.LibSwingUtil;

public final class EditReportConfigurationAction
extends AbstractReportContextAction {
    public EditReportConfigurationAction() {
        this.putValue("Name", ActionMessages.getString("EditReportConfigurationAction.Text", new Object[0]));
        this.putValue("Default", ActionMessages.getString("EditReportConfigurationAction.Description", new Object[0]));
        this.putValue("MnemonicKey", ActionMessages.getOptionalMnemonic("EditReportConfigurationAction.Mnemonic"));
        this.putValue("AcceleratorKey", ActionMessages.getOptionalKeyStroke("EditReportConfigurationAction.Accelerator"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ReportDocumentContext activeContext = this.getReportDesignerContext().getActiveContext();
        if (activeContext == null) {
            return;
        }
        Window window = LibSwingUtil.getWindowAncestor((Component)this.getReportDesignerContext().getView().getParent());
        ConfigurationEditorDialog dialog = window instanceof JDialog ? new ConfigurationEditorDialog((JDialog)window) : (window instanceof JFrame ? new ConfigurationEditorDialog((JFrame)window) : new ConfigurationEditorDialog());
        HierarchicalConfiguration config = (HierarchicalConfiguration)((MasterReport)activeContext.getContextRoot()).getReportConfiguration();
        HashMap oldConfig = this.copyConfig(config);
        if (dialog.performEdit((ModifiableConfiguration)config)) {
            HashMap newConfig = this.copyConfig(config);
            activeContext.getUndo().addChange(ActionMessages.getString("EditReportConfigurationAction.Text", new Object[0]), new EditReportConfigUndoEntry(oldConfig, newConfig));
            ((MasterReport)activeContext.getContextRoot()).notifyNodeStructureChanged();
        }
    }

    private HashMap copyConfig(HierarchicalConfiguration config) {
        Enumeration configProperties = config.getConfigProperties();
        HashMap<String, String> oldConfig = new HashMap<String, String>();
        while (configProperties.hasMoreElements()) {
            String key = (String)configProperties.nextElement();
            if (!config.isLocallyDefined(key)) continue;
            oldConfig.put(key, config.getConfigProperty(key));
        }
        return oldConfig;
    }
}

