/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.actions.report;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.actions.AbstractReportContextAction;
import org.pentaho.reporting.designer.core.actions.ActionMessages;
import org.pentaho.reporting.designer.core.editor.ReportRenderContext;
import org.pentaho.reporting.designer.core.editor.migration.MigrationDialog;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.designtime.AttributeChange;
import org.pentaho.reporting.engine.classic.core.event.ReportModelEvent;
import org.pentaho.reporting.engine.classic.core.event.ReportModelListener;
import org.pentaho.reporting.libraries.designtime.swing.LibSwingUtil;

public class MigrateReportAction
extends AbstractReportContextAction {
    private MigrationUpdateListener updateListener;

    public MigrateReportAction() {
        this.putValue("Name", ActionMessages.getString("MigrateReportAction.Text", new Object[0]));
        this.putValue("Default", ActionMessages.getString("MigrateReportAction.Description", new Object[0]));
        this.putValue("MnemonicKey", ActionMessages.getOptionalMnemonic("MigrateReportAction.Mnemonic"));
        this.putValue("AcceleratorKey", ActionMessages.getOptionalKeyStroke("MigrateReportAction.Accelerator"));
        this.updateListener = new MigrationUpdateListener();
    }

    @Override
    protected void updateActiveContext(ReportRenderContext oldContext, ReportRenderContext newContext) {
        if (oldContext != null) {
            oldContext.getMasterReportElement().removeReportModelListener((ReportModelListener)this.updateListener);
        }
        if (newContext == null) {
            this.setEnabled(false);
            return;
        }
        newContext.getMasterReportElement().addReportModelListener((ReportModelListener)this.updateListener);
        AbstractReportDefinition reportDefinition = newContext.getReportDefinition();
        if (!(reportDefinition instanceof MasterReport)) {
            this.setEnabled(false);
            return;
        }
        this.updateCompatibilityLevel((MasterReport)reportDefinition);
    }

    protected void updateCompatibilityLevel(MasterReport reportDefinition) {
        Integer compatibilityLevel = reportDefinition.getCompatibilityLevel();
        if (compatibilityLevel == null) {
            this.setEnabled(false);
            return;
        }
        if (compatibilityLevel <= 0) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled(compatibilityLevel < ClassicEngineBoot.computeCurrentVersionId());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ReportDesignerContext context = this.getReportDesignerContext();
        MigrateReportAction.migrateReport(context);
    }

    public static void migrateReport(ReportDesignerContext context) {
        Component parent = context.getView().getParent();
        Window window = LibSwingUtil.getWindowAncestor((Component)parent);
        MigrationDialog dialog = window instanceof JDialog ? new MigrationDialog((JDialog)window) : (window instanceof JFrame ? new MigrationDialog((JFrame)window) : new MigrationDialog());
        dialog.performMigration(context, context.getActiveContext());
    }

    private class MigrationUpdateListener
    implements ReportModelListener {
        private MigrationUpdateListener() {
        }

        public void nodeChanged(ReportModelEvent event) {
            AttributeChange change;
            if (event.getType() != 0) {
                return;
            }
            if (!(event.getElement() instanceof MasterReport)) {
                return;
            }
            MasterReport masterReport = (MasterReport)event.getElement();
            Object parameter = event.getParameter();
            if (parameter instanceof AttributeChange && "http://reporting.pentaho.org/namespaces/engine/attributes/internal".equals((change = (AttributeChange)parameter).getNamespace()) && "compatibility-level".equals(change.getName())) {
                MigrateReportAction.this.updateCompatibilityLevel(masterReport);
            }
        }
    }
}

