/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.auth;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.pentaho.reporting.designer.core.settings.WorkspaceSettings;
import org.pentaho.reporting.designer.core.util.exceptions.UncaughtExceptionsModel;

public class PasswordPolicyManager {
    private static PasswordPolicyManager instance;
    private Preferences properties;
    private LinkedHashSet<String> hosts;

    public static synchronized PasswordPolicyManager getInstance() {
        if (instance == null) {
            instance = new PasswordPolicyManager();
        }
        return instance;
    }

    private PasswordPolicyManager() {
        Preferences preferences = Preferences.userNodeForPackage(PasswordPolicyManager.class);
        this.properties = preferences.node("PasswordPolicy");
        this.hosts = new LinkedHashSet();
        try {
            this.hosts.addAll(this.getFilesAsList());
        }
        catch (BackingStoreException e) {
            UncaughtExceptionsModel.getInstance().addException(e);
        }
    }

    public boolean isPasswordStoringAllowed(String url) {
        if (!WorkspaceSettings.getInstance().isRememberPasswords()) {
            return false;
        }
        return !this.hosts.contains(url);
    }

    public void setPasswordStoringAllowed(String url, boolean allowed) {
        if (!allowed) {
            if (this.hosts.add(url)) {
                try {
                    this.store(this.hosts);
                }
                catch (BackingStoreException e) {
                    UncaughtExceptionsModel.getInstance().addException(e);
                }
            }
        } else if (this.hosts.remove(url)) {
            try {
                this.store(this.hosts);
            }
            catch (BackingStoreException e) {
                UncaughtExceptionsModel.getInstance().addException(e);
            }
        }
    }

    public String[] getManagedHosts() {
        return this.hosts.toArray(new String[this.hosts.size()]);
    }

    private LinkedHashSet<String> getFilesAsList() throws BackingStoreException {
        LinkedHashSet<String> retval = new LinkedHashSet<String>();
        String[] strings = this.properties.keys();
        int maxFiles = Math.min(10, strings.length);
        for (int i = 0; i < maxFiles; ++i) {
            String key = strings[i];
            String file = this.properties.get(key, null);
            if (file == null) continue;
            retval.add(file);
        }
        if (retval.size() != strings.length) {
            this.store(retval);
        }
        return retval;
    }

    private void store(Collection<String> files) throws BackingStoreException {
        this.properties.clear();
        String[] strings = files.toArray(new String[files.size()]);
        for (int i = 0; i < strings.length; ++i) {
            String string = strings[i];
            this.properties.put(String.valueOf(i), string);
        }
        this.properties.flush();
    }
}

