/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import org.pentaho.reporting.designer.core.Messages;
import org.pentaho.reporting.designer.core.util.exceptions.UncaughtExceptionsModel;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.libraries.base.boot.AbstractBoot;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.config.HierarchicalConfiguration;
import org.pentaho.reporting.libraries.base.config.ModifiableConfiguration;
import org.pentaho.reporting.libraries.designtime.swing.CommonDialog;
import org.pentaho.reporting.libraries.designtime.swing.LibSwingUtil;
import org.pentaho.reporting.tools.configeditor.ConfigEditorPane;

public class ConfigurationEditorDialog
extends CommonDialog {
    private ConfigEditorPane editorPane;

    public ConfigurationEditorDialog() {
        this.init();
    }

    public ConfigurationEditorDialog(Frame owner) {
        super(owner);
        this.init();
    }

    public ConfigurationEditorDialog(Dialog owner) {
        super(owner);
        this.init();
    }

    protected Component createContentPane() {
        this.setTitle(Messages.getString("ConfigurationEditorDialog.Title", new Object[0]));
        this.editorPane = new ConfigEditorPane((AbstractBoot)ClassicEngineBoot.getInstance(), false);
        this.editorPane.setPreferredSize(new Dimension(825, 425));
        try {
            this.editorPane.load(false);
        }
        catch (IOException ioe) {
            UncaughtExceptionsModel.getInstance().addException(ioe);
        }
        return this.editorPane;
    }

    protected String getDialogId() {
        return "ReportDesigner.Core.Configuration";
    }

    public boolean performEdit(ModifiableConfiguration config) {
        HashSet<String> existingKeys = new HashSet<String>();
        HierarchicalConfiguration hconf = new HierarchicalConfiguration((Configuration)config);
        if (config instanceof HierarchicalConfiguration) {
            HierarchicalConfiguration oconf = (HierarchicalConfiguration)config;
            Enumeration configProperties = oconf.getConfigProperties();
            while (configProperties.hasMoreElements()) {
                String key = (String)configProperties.nextElement();
                hconf.setConfigProperty(key, oconf.getConfigProperty(key));
                existingKeys.add(key);
            }
        }
        this.editorPane.updateConfiguration(hconf);
        if (!this.performEdit()) {
            return false;
        }
        this.editorPane.commit();
        Enumeration configProperties = hconf.getConfigProperties();
        while (configProperties.hasMoreElements()) {
            String key = (String)configProperties.nextElement();
            config.setConfigProperty(key, hconf.getConfigProperty(key));
            existingKeys.remove(key);
        }
        String[] keys = existingKeys.toArray(new String[existingKeys.size()]);
        for (int i = 0; i < keys.length; ++i) {
            String key = keys[i];
            config.setConfigProperty(key, null);
        }
        return true;
    }

    protected void performInitialResize() {
        this.setSize(825, 425);
        LibSwingUtil.centerDialogInParent((Dialog)((Object)this));
    }

    public static void main(String[] args) {
        ClassicEngineBoot.getInstance().start();
        ConfigurationEditorDialog dialog = new ConfigurationEditorDialog();
        dialog.performEdit(ClassicEngineBoot.getInstance().getEditableConfig());
    }
}

