/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor;

import java.io.IOException;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.designer.core.util.exceptions.UncaughtExceptionsModel;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.designtime.AttributeChange;
import org.pentaho.reporting.engine.classic.core.event.ReportModelEvent;
import org.pentaho.reporting.engine.classic.core.event.ReportModelListener;
import org.pentaho.reporting.engine.classic.core.metadata.AttributeMetaData;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.ClassicEngineFactoryParameters;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceKeyCreationException;
import org.pentaho.reporting.libraries.resourceloader.ResourceKeyUtils;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoadingException;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class ResourceLoaderListener
implements ReportModelListener {
    private static final Log logger = LogFactory.getLog(ResourceLoaderListener.class);
    private MasterReport masterReportElement;

    public ResourceLoaderListener(MasterReport masterReportElement, AbstractReportDefinition report) {
        this.masterReportElement = masterReportElement;
    }

    public void nodeChanged(ReportModelEvent event) {
        if (!(event.getParameter() instanceof AttributeChange) || !(event.getElement() instanceof ReportElement)) {
            return;
        }
        AttributeChange attributeChange = (AttributeChange)event.getParameter();
        ReportElement reportElement = (ReportElement)event.getElement();
        AttributeMetaData attributeDescription = reportElement.getMetaData().getAttributeDescription(attributeChange.getNamespace(), attributeChange.getName());
        if (attributeDescription == null || !"Resource".equals(attributeDescription.getValueRole())) {
            return;
        }
        Object newValue = attributeChange.getNewValue();
        if (newValue instanceof ResourceKey && ResourceLoaderListener.shouldBeLoaded((ResourceKey)newValue)) {
            try {
                ResourceKey newKey = this.loadResourceIntoKey((ResourceKey)newValue);
                if (newKey != null) {
                    reportElement.setAttribute(attributeChange.getNamespace(), attributeChange.getName(), (Object)newKey);
                }
            }
            catch (Exception e) {
                reportElement.setAttribute(attributeChange.getNamespace(), attributeChange.getName(), null);
                UncaughtExceptionsModel.getInstance().addException(e);
            }
        }
    }

    private ResourceKey loadResourceIntoKey(ResourceKey key) throws IOException, ResourceKeyCreationException, ResourceLoadingException {
        if (logger.isDebugEnabled()) {
            Map factoryParameters = key.getFactoryParameters();
            String mimeType = (String)factoryParameters.get(ClassicEngineFactoryParameters.MIME_TYPE);
            String pattern = (String)factoryParameters.get(ClassicEngineFactoryParameters.PATTERN);
            String original = (String)factoryParameters.get(ClassicEngineFactoryParameters.ORIGINAL_VALUE);
            logger.debug((Object)("Loading resource into key: original=[" + original + "] mimeType=[" + mimeType + "] pattern=[" + pattern + "]"));
        }
        return ResourceKeyUtils.embedResourceInKey((ResourceManager)this.masterReportElement.getResourceManager(), (ResourceKey)key, (Map)key.getFactoryParameters());
    }

    private static boolean shouldBeLoaded(ResourceKey key) {
        return "true".equals(key.getFactoryParameters().get(ClassicEngineFactoryParameters.EMBED)) && false == key.getIdentifier() instanceof byte[];
    }
}

