/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor;

import java.awt.Dimension;
import java.awt.SystemColor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.text.DecimalFormat;
import javax.swing.JLabel;
import org.pentaho.reporting.designer.core.editor.ZoomModel;
import org.pentaho.reporting.designer.core.editor.ZoomModelListener;

public class ZoomController
extends JLabel {
    private ZoomModel zoomModel;
    private DecimalFormat format;

    public ZoomController(ZoomModel model) {
        if (model == null) {
            throw new NullPointerException();
        }
        this.format = new DecimalFormat("##0%");
        this.zoomModel = model;
        this.zoomModel.addZoomModelListener(new ZoomUpdateHandler());
        this.setBackground(SystemColor.control);
        this.setHorizontalAlignment(0);
        this.setText(this.format.format(this.zoomModel.getZoomAsPercentage()));
        ZoomHandler zoomHandler = new ZoomHandler();
        this.addMouseListener(zoomHandler);
        this.addMouseMotionListener(zoomHandler);
        this.addMouseWheelListener(zoomHandler);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    private class ZoomUpdateHandler
    implements ZoomModelListener {
        private ZoomUpdateHandler() {
        }

        @Override
        public void zoomFactorChanged() {
            ZoomController.this.setText(ZoomController.this.format.format(ZoomController.this.zoomModel.getZoomAsPercentage()));
        }
    }

    private class ZoomHandler
    extends MouseAdapter
    implements MouseMotionListener,
    MouseWheelListener {
        private int dragStartPoint;

        private ZoomHandler() {
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            float diff = (float)e.getWheelRotation() * 0.01f;
            float zoomFactor = ZoomController.this.zoomModel.getZoomAsPercentage();
            ZoomController.this.zoomModel.setZoomAsPercentage(Math.min(5.0f, Math.max(0.1f, zoomFactor - diff)));
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2 && e.getButton() == 1) {
                ZoomController.this.zoomModel.setZoomAsPercentage(1.0f);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.dragStartPoint = e.getX();
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            float diff = (float)(this.dragStartPoint - e.getX()) * 0.01f;
            float zoomFactor = ZoomController.this.zoomModel.getZoomAsPercentage();
            ZoomController.this.zoomModel.setZoomAsPercentage(Math.min(5.0f, Math.max(0.1f, zoomFactor - diff)));
            this.dragStartPoint = e.getX();
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }
    }
}

