/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.attributes;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.JScrollPane;
import javax.swing.table.TableCellEditor;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.editor.attributes.AttributeTableModel;
import org.pentaho.reporting.designer.core.model.selection.DocumentContextSelectionModel;
import org.pentaho.reporting.designer.core.util.SidePanel;
import org.pentaho.reporting.designer.core.util.table.ElementMetaDataTable;
import org.pentaho.reporting.designer.core.util.table.GroupedNameCellRenderer;
import org.pentaho.reporting.designer.core.util.table.SortHeaderPanel;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.event.ReportModelEvent;
import org.pentaho.reporting.engine.classic.core.event.ReportModelListener;

public class AttributeEditorPanel
extends SidePanel {
    private static final ReportElement[] EMPTY_DATA = new ReportElement[0];
    private AttributeTableModel dataModel;
    private ElementMetaDataTable table;
    private AbstractReportDefinition report;
    private ReportModelChangeHandler changeHandler;
    private SortHeaderPanel headerPanel;

    public AttributeEditorPanel() {
        this.setLayout(new BorderLayout());
        this.changeHandler = new ReportModelChangeHandler();
        this.dataModel = new AttributeTableModel();
        this.table = new ElementMetaDataTable();
        this.table.setModel(this.dataModel);
        this.table.getColumnModel().getColumn(0).setCellRenderer(new GroupedNameCellRenderer());
        this.headerPanel = new SortHeaderPanel(this.dataModel);
        this.add((Component)this.headerPanel, "North");
        this.add((Component)new JScrollPane(this.table), "Center");
    }

    @Override
    protected void updateSelection(DocumentContextSelectionModel model) {
        List<Element> selectedElementsOfType = model.getSelectedElementsOfType(Element.class);
        Element[] visualElements = selectedElementsOfType.toArray(new Element[selectedElementsOfType.size()]);
        this.setData((ReportElement[])visualElements);
    }

    public ReportElement[] getData() {
        return this.dataModel.getData();
    }

    public void setData(ReportElement[] elements) {
        TableCellEditor tableCellEditor = this.table.getCellEditor();
        if (tableCellEditor != null) {
            tableCellEditor.stopCellEditing();
        }
        this.dataModel.setData(elements);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.table.setEnabled(enabled);
        this.headerPanel.setEnabled(enabled);
    }

    @Override
    protected void updateActiveContext(ReportDocumentContext oldContext, ReportDocumentContext newContext) {
        this.table.stopEditing();
        super.updateActiveContext(oldContext, newContext);
        if (this.report != null) {
            this.report.removeReportModelListener((ReportModelListener)this.changeHandler);
        }
        if (newContext == null) {
            this.report = null;
            this.dataModel.setReportRenderContext(null);
            this.setData(EMPTY_DATA);
        } else {
            this.report = newContext.getReportDefinition();
            this.dataModel.setReportRenderContext(newContext);
            this.report.addReportModelListener((ReportModelListener)this.changeHandler);
        }
    }

    @Override
    protected void updateDesignerContext(ReportDesignerContext oldContext, ReportDesignerContext newContext) {
        super.updateDesignerContext(oldContext, newContext);
        this.table.setReportDesignerContext(newContext);
    }

    private class ReportModelChangeHandler
    implements ReportModelListener {
        private ReportModelChangeHandler() {
        }

        public void nodeChanged(ReportModelEvent event) {
            if (!(event.getElement() instanceof ReportElement)) {
                return;
            }
            Object element = event.getElement();
            ReportElement[] data = AttributeEditorPanel.this.getData();
            for (int i = 0; i < data.length; ++i) {
                ReportElement reportElement = data[i];
                if (element != reportElement) continue;
                AttributeEditorPanel.this.dataModel.setData(data);
                return;
            }
        }
    }
}

