/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.crosstab;

import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.table.AbstractTableModel;
import org.pentaho.reporting.designer.core.Messages;
import org.pentaho.reporting.engine.classic.core.elementfactory.CrosstabDimension;
import org.pentaho.reporting.libraries.designtime.swing.bulk.BulkDataProvider;

public class CrosstabDimensionTableModel
extends AbstractTableModel
implements BulkDataProvider {
    private ArrayList<CrosstabDimension> data = new ArrayList();

    public void setData(CrosstabDimension[] data) {
        if (data == null) {
            throw new NullPointerException();
        }
        this.data.clear();
        this.data.addAll(Arrays.asList(data));
        this.fireTableDataChanged();
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        CrosstabDimension crosstabDimension = this.data.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return crosstabDimension.getField();
            }
            case 1: {
                return crosstabDimension.getTitle();
            }
            case 2: {
                return crosstabDimension.isPrintSummary();
            }
            case 3: {
                return crosstabDimension.getSummaryTitle();
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        CrosstabDimension crosstabDimension = this.get(rowIndex);
        switch (columnIndex) {
            case 1: {
                crosstabDimension.setTitle((String)value);
                break;
            }
            case 2: {
                if (value != null) {
                    crosstabDimension.setPrintSummary(((Boolean)value).booleanValue());
                    break;
                }
                crosstabDimension.setPrintSummary(false);
                break;
            }
            case 3: {
                crosstabDimension.setSummaryTitle((String)value);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        this.data.set(rowIndex, crosstabDimension);
        this.fireTableCellUpdated(rowIndex, columnIndex);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex != 0;
    }

    public Class getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return String.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return Boolean.class;
            }
            case 3: {
                return String.class;
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return Messages.getString("CrosstabDimensionTableModel.Field", new Object[0]);
            }
            case 1: {
                return Messages.getString("CrosstabDimensionTableModel.TitleHeader", new Object[0]);
            }
            case 2: {
                return Messages.getString("CrosstabDimensionTableModel.PrintSummary", new Object[0]);
            }
            case 3: {
                return Messages.getString("CrosstabDimensionTableModel.SummaryHeader", new Object[0]);
            }
        }
        throw new IllegalStateException();
    }

    public void add(CrosstabDimension o) {
        this.data.add(o);
        this.fireTableDataChanged();
    }

    public void add(int idx, CrosstabDimension item) {
        this.data.add(idx, item);
        this.fireTableDataChanged();
    }

    public CrosstabDimension get(int index) {
        return this.data.get(index);
    }

    public void remove(int index) {
        this.data.remove(index);
        this.fireTableDataChanged();
    }

    public void clear() {
        this.data.clear();
        this.fireTableDataChanged();
    }

    public CrosstabDimension[] toArray() {
        return this.data.toArray(new CrosstabDimension[this.data.size()]);
    }

    public int size() {
        return this.getRowCount();
    }

    public int getBulkDataSize() {
        return this.getRowCount();
    }

    public Object[] getBulkData() {
        return this.toArray();
    }

    public void setBulkData(Object[] data) {
        this.data.clear();
        for (int i = 0; i < data.length; ++i) {
            Object o = data[i];
            this.data.add((CrosstabDimension)o);
        }
        this.fireTableDataChanged();
    }
}

