/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.drilldown;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.pentaho.reporting.designer.core.Messages;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.util.ExpressionEditorPane;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.function.FormulaExpression;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleSheet;
import org.pentaho.reporting.engine.classic.core.style.StyleKey;
import org.pentaho.reporting.libraries.base.util.StringUtils;

public class BasicLinkPanel
extends JPanel {
    private ExpressionEditorPane targetFormula;
    private JTextField targetField = new JTextField();
    private ExpressionEditorPane titleFormula;
    private ExpressionEditorPane windowFormula;
    private JComboBox windowComboBox;
    private JTextField titleField;

    public BasicLinkPanel() {
        this.targetFormula = new ExpressionEditorPane();
        this.windowComboBox = new JComboBox<String>(new String[]{"", "_blank", "_self", "_parent", "_top"});
        this.windowComboBox.setEditable(true);
        this.titleField = new JTextField();
        this.titleFormula = new ExpressionEditorPane();
        this.windowFormula = new ExpressionEditorPane();
        this.setLayout(new BorderLayout());
        JPanel theMainPanel = new JPanel();
        theMainPanel.setLayout(new GridLayout(3, 1));
        theMainPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel theUpperMainPanel = new JPanel();
        theUpperMainPanel.setLayout(new BorderLayout());
        theUpperMainPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("HyperlinkPropertiesPane.Link", new Object[0])));
        JPanel theUpperPanel = new JPanel();
        theUpperPanel.setLayout(new GridLayout(4, 1));
        theUpperPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        theUpperPanel.add(new JLabel(Messages.getString("HyperlinkPropertiesPane.Value", new Object[0])));
        theUpperPanel.add(this.targetField);
        theUpperPanel.add(new JLabel(Messages.getString("HyperlinkPropertiesPane.Formula", new Object[0])));
        theUpperPanel.add(this.targetFormula);
        theUpperMainPanel.add((Component)theUpperPanel, "Center");
        theMainPanel.add(theUpperMainPanel);
        JPanel theMidMainPanel = new JPanel();
        theMidMainPanel.setLayout(new BorderLayout());
        theMidMainPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("HyperlinkPropertiesPane.Title", new Object[0])));
        JPanel theMidPanel = new JPanel();
        theMidPanel.setLayout(new GridLayout(4, 1));
        theMidPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        theMidPanel.add(new JLabel(Messages.getString("HyperlinkPropertiesPane.Value", new Object[0])));
        theMidPanel.add(this.titleField);
        theMidPanel.add(new JLabel(Messages.getString("HyperlinkPropertiesPane.Formula", new Object[0])));
        theMidPanel.add(this.titleFormula);
        theMidMainPanel.add((Component)theMidPanel, "Center");
        theMainPanel.add(theMidMainPanel);
        JPanel theBottomMainPanel = new JPanel();
        theBottomMainPanel.setLayout(new BorderLayout());
        theBottomMainPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("HyperlinkPropertiesPane.Window", new Object[0])));
        JPanel theBottomPanel = new JPanel();
        theBottomPanel.setLayout(new GridLayout(4, 1));
        theBottomPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        theBottomPanel.add(new JLabel(Messages.getString("HyperlinkPropertiesPane.Value", new Object[0])));
        theBottomPanel.add(this.windowComboBox);
        theBottomPanel.add(new JLabel(Messages.getString("HyperlinkPropertiesPane.Formula", new Object[0])));
        theBottomPanel.add(this.windowFormula);
        theBottomMainPanel.add((Component)theBottomPanel, "Center");
        theMainPanel.add(theBottomMainPanel);
        this.add((Component)theMainPanel, "North");
    }

    public void commitValues(ElementStyleSheet styleSheet, Map<StyleKey, Expression> styleExpressions) {
        if (styleExpressions == null) {
            throw new NullPointerException();
        }
        Expression formulaValue = this.targetFormula.getValue();
        if (formulaValue != null) {
            styleExpressions.put(ElementStyleKeys.HREF_TARGET, formulaValue);
        } else {
            styleExpressions.remove(ElementStyleKeys.HREF_TARGET);
        }
        String targetRawValue = this.targetField.getText();
        if (targetRawValue.trim().length() > 0) {
            styleSheet.setStyleProperty(ElementStyleKeys.HREF_TARGET, (Object)targetRawValue);
        } else {
            styleSheet.setStyleProperty(ElementStyleKeys.HREF_TARGET, null);
        }
        Expression windowFormulaValue = this.windowFormula.getValue();
        if (windowFormulaValue != null) {
            styleExpressions.put(ElementStyleKeys.HREF_WINDOW, windowFormulaValue);
        } else {
            styleExpressions.remove(ElementStyleKeys.HREF_WINDOW);
        }
        String windowValueRaw = (String)this.windowComboBox.getSelectedItem();
        if (!StringUtils.isEmpty((String)windowValueRaw, (boolean)true)) {
            styleSheet.setStyleProperty(ElementStyleKeys.HREF_WINDOW, (Object)windowValueRaw);
        } else {
            styleSheet.setStyleProperty(ElementStyleKeys.HREF_WINDOW, null);
        }
        Expression titleFormulaValue = this.titleFormula.getValue();
        if (titleFormulaValue != null) {
            styleExpressions.put(ElementStyleKeys.HREF_TITLE, titleFormulaValue);
        } else {
            styleExpressions.remove(ElementStyleKeys.HREF_TITLE);
        }
        String titleValueRaw = this.titleField.getText();
        if (!StringUtils.isEmpty((String)titleValueRaw, (boolean)true)) {
            styleSheet.setStyleProperty(ElementStyleKeys.HREF_TITLE, (Object)titleValueRaw);
        } else {
            styleSheet.setStyleProperty(ElementStyleKeys.HREF_TITLE, null);
        }
    }

    public void initializeFromStyle(ElementStyleSheet styleSheet, Map styleExpressions, ReportDesignerContext renderContext) {
        this.targetFormula.setReportDesignerContext(renderContext);
        this.windowFormula.setReportDesignerContext(renderContext);
        this.titleFormula.setReportDesignerContext(renderContext);
        if (styleExpressions.containsKey(ElementStyleKeys.HREF_TARGET)) {
            this.targetFormula.setValue((Expression)styleExpressions.get(ElementStyleKeys.HREF_TARGET));
            this.targetField.setText("");
        } else {
            this.targetField.setText((String)styleSheet.getStyleProperty(ElementStyleKeys.HREF_TARGET));
            this.targetFormula.setValue(null);
        }
        if (styleExpressions.containsKey(ElementStyleKeys.HREF_WINDOW)) {
            this.windowFormula.setValue((Expression)styleExpressions.get(ElementStyleKeys.HREF_WINDOW));
            this.windowComboBox.setSelectedIndex(-1);
        } else {
            this.windowComboBox.setSelectedItem(styleSheet.getStyleProperty(ElementStyleKeys.HREF_WINDOW));
            this.windowFormula.setValue(null);
        }
        if (styleExpressions.containsKey(ElementStyleKeys.HREF_TITLE)) {
            this.titleFormula.setValue((Expression)styleExpressions.get(ElementStyleKeys.HREF_TITLE));
            this.titleField.setText("");
        } else {
            this.titleField.setText((String)styleSheet.getStyleProperty(ElementStyleKeys.HREF_TITLE));
            this.titleFormula.setValue(null);
        }
    }

    public String getFormulaText() {
        Expression value = this.targetFormula.getValue();
        if (value instanceof FormulaExpression) {
            FormulaExpression formulaExpression = (FormulaExpression)value;
            return formulaExpression.getFormula();
        }
        return null;
    }

    public void setFormulaText(String text) {
        if (StringUtils.isEmpty((String)text, (boolean)true)) {
            return;
        }
        if (text.equals(this.getFormulaText())) {
            return;
        }
        FormulaExpression fe = new FormulaExpression();
        fe.setFormula(text);
        this.targetFormula.setValue((Expression)fe);
    }

    public boolean isEmpty() {
        return this.targetFormula.getValue() == null && StringUtils.isEmpty((String)this.targetField.getText(), (boolean)true);
    }
}

