/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.drilldown;

import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Arrays;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.pentaho.reporting.designer.core.editor.drilldown.DrillDownSelector;
import org.pentaho.reporting.designer.core.editor.drilldown.DrillDownUiProfile;
import org.pentaho.reporting.designer.core.editor.drilldown.DrillDownUiProfileComparator;
import org.pentaho.reporting.designer.core.editor.drilldown.DrillDownUiProfileRegistry;

public class ComboBoxSelector
extends JComboBox
implements DrillDownSelector {
    private EventListenerList eventListeners = new EventListenerList();

    public ComboBoxSelector(boolean allowManualMode) {
        this.setRenderer(new DrillDownProfileRenderer());
        this.setModel(this.createModel(allowManualMode));
        this.addItemListener(new DrillDownItemListener());
    }

    @Override
    public DrillDownUiProfile getSelectedProfile() {
        return (DrillDownUiProfile)this.getSelectedItem();
    }

    @Override
    public void setSelectedProfile(DrillDownUiProfile profile) {
        this.setSelectedItem(profile);
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    private DefaultComboBoxModel createModel(boolean allowManualMode) {
        DrillDownUiProfileRegistry metaData = DrillDownUiProfileRegistry.getInstance();
        DrillDownUiProfile[] drilldownProfiles = metaData.getProfiles();
        Arrays.sort(drilldownProfiles, new DrillDownUiProfileComparator());
        DefaultComboBoxModel<DrillDownUiProfile> comboBoxModel = new DefaultComboBoxModel<DrillDownUiProfile>(drilldownProfiles);
        if (allowManualMode) {
            comboBoxModel.addElement(null);
        }
        return comboBoxModel;
    }

    @Override
    public void addChangeListener(ChangeListener changeListener) {
        if (changeListener == null) {
            throw new NullPointerException();
        }
        this.eventListeners.add(ChangeListener.class, changeListener);
    }

    @Override
    public void removeChangeListener(ChangeListener changeListener) {
        if (changeListener == null) {
            throw new NullPointerException();
        }
        this.eventListeners.remove(ChangeListener.class, changeListener);
    }

    private void fireChangeEvent() {
        ChangeListener[] changeListeners = (ChangeListener[])this.eventListeners.getListeners(ChangeListener.class);
        ChangeEvent event = new ChangeEvent(this);
        for (int i = 0; i < changeListeners.length; ++i) {
            ChangeListener listener = changeListeners[i];
            listener.stateChanged(event);
        }
    }

    private class DrillDownItemListener
    implements ItemListener {
        private DrillDownItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            ComboBoxSelector.this.fireChangeEvent();
        }
    }

    private static class DrillDownProfileRenderer
    extends DefaultListCellRenderer {
        private DrillDownProfileRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value == null) {
                this.setText("Manual Linking");
            } else {
                DrillDownUiProfile profile = (DrillDownUiProfile)value;
                this.setText(profile.getDisplayName());
            }
            return this;
        }
    }
}

