/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.drilldown;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.pentaho.reporting.designer.core.Messages;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.editor.drilldown.DrillDownParameterRefreshEvent;
import org.pentaho.reporting.designer.core.editor.drilldown.DrillDownParameterRefreshListener;
import org.pentaho.reporting.designer.core.editor.drilldown.DrillDownParameterTableModel;
import org.pentaho.reporting.designer.core.editor.drilldown.FilteringParameterTableModel;
import org.pentaho.reporting.designer.core.editor.drilldown.SystemParameterDialog;
import org.pentaho.reporting.designer.core.editor.drilldown.model.DrillDownParameter;
import org.pentaho.reporting.designer.core.util.IconLoader;
import org.pentaho.reporting.designer.core.util.table.ElementMetaDataTable;
import org.pentaho.reporting.designer.core.util.table.FormulaFragmentCellRenderer;
import org.pentaho.reporting.designer.core.util.table.GroupedMetaTableModel;
import org.pentaho.reporting.designer.core.util.table.GroupedName;
import org.pentaho.reporting.designer.core.util.table.GroupedNameCellEditor;
import org.pentaho.reporting.designer.core.util.table.GroupedTableModel;
import org.pentaho.reporting.libraries.designtime.swing.BorderlessButton;
import org.pentaho.reporting.libraries.designtime.swing.LibSwingUtil;

public class DrillDownParameterTable
extends JComponent {
    public static final String DRILL_DOWN_PARAMETER_PROPERTY = "drillDownParameter";
    public static final String HIDE_PARAMETER_UI_PARAMETER_PROPERTY = "hideParameterUi";
    private DrillDownParameterTableModel parameterTableModel;
    private boolean allowCustomParameter;
    private boolean showRefreshButton;
    private JLabel title;
    private ArrayList<DrillDownParameterRefreshListener> listeners;
    private RefreshParameterAction refreshParameterAction;
    private boolean singleTabMode;
    private JCheckBox hideParameterUiCheckbox;
    private ElementMetaDataTable allInOneTable;
    private ElementMetaDataTable systemParameterTable;
    private ElementMetaDataTable manualParameterTable;
    private ElementMetaDataTable predefinedParameterTable;
    private RemoveParameterAction allInOneRemoveAction;
    private RemoveParameterAction manualParameterRemoveAction;
    private ReportDesignerContext reportDesignerContext;
    private AddParameterAction addParameterAction;
    private ShowAdvancedEditorAction advancedEditorAction;

    public DrillDownParameterTable() {
        this.setLayout(new BorderLayout());
        this.listeners = new ArrayList();
        this.refreshParameterAction = new RefreshParameterAction();
        this.addParameterAction = new AddParameterAction();
        this.advancedEditorAction = new ShowAdvancedEditorAction();
        this.parameterTableModel = new DrillDownParameterTableModel();
        this.parameterTableModel.addTableModelListener(new DrillDownParameterChangeHandler());
        this.allInOneTable = new ElementMetaDataTable();
        this.allInOneTable.setFormulaFragment(true);
        this.allInOneTable.setDefaultEditor(GroupedName.class, new GroupedNameCellEditor());
        this.allInOneTable.setDefaultRenderer(String.class, new FormulaFragmentCellRenderer());
        this.allInOneTable.setModel(new GroupedMetaTableModel(this.parameterTableModel));
        this.allInOneRemoveAction = new RemoveParameterAction(this.allInOneTable);
        this.systemParameterTable = new ElementMetaDataTable();
        this.systemParameterTable.setFormulaFragment(true);
        this.systemParameterTable.setDefaultEditor(GroupedName.class, new GroupedNameCellEditor());
        this.systemParameterTable.setDefaultRenderer(String.class, new FormulaFragmentCellRenderer());
        this.systemParameterTable.setModel(new FilteringParameterTableModel(DrillDownParameter.Type.SYSTEM, this.parameterTableModel, true));
        this.manualParameterTable = new ElementMetaDataTable();
        this.manualParameterTable.setFormulaFragment(true);
        this.manualParameterTable.setDefaultEditor(GroupedName.class, new GroupedNameCellEditor());
        this.manualParameterTable.setDefaultRenderer(String.class, new FormulaFragmentCellRenderer());
        this.manualParameterTable.setModel(new FilteringParameterTableModel(DrillDownParameter.Type.MANUAL, this.parameterTableModel));
        this.manualParameterRemoveAction = new RemoveParameterAction(this.manualParameterTable);
        this.predefinedParameterTable = new ElementMetaDataTable();
        this.predefinedParameterTable.setFormulaFragment(true);
        this.predefinedParameterTable.setDefaultEditor(GroupedName.class, new GroupedNameCellEditor());
        this.predefinedParameterTable.setDefaultRenderer(String.class, new FormulaFragmentCellRenderer());
        this.predefinedParameterTable.setModel(new FilteringParameterTableModel(DrillDownParameter.Type.PREDEFINED, this.parameterTableModel));
        this.hideParameterUiCheckbox = new JCheckBox(Messages.getString("DrillDownParameterTable.HideParameterUI", new Object[0]));
        this.hideParameterUiCheckbox.addItemListener(new HideParamUiSelectionListener());
        this.title = new JLabel(Messages.getString("DrillDownParameterTable.Title", new Object[0]));
        this.rebuildUi();
    }

    private void rebuildUi() {
        this.removeAll();
        if (this.isSingleTabMode()) {
            JPanel buttonPanel = new JPanel();
            buttonPanel.setLayout(new FlowLayout(2));
            if (this.isShowRefreshButton()) {
                buttonPanel.add((Component)new BorderlessButton((Action)this.refreshParameterAction));
                if (this.isAllowCustomParameter()) {
                    buttonPanel.add(Box.createHorizontalStrut(10));
                }
            }
            if (this.isAllowCustomParameter()) {
                buttonPanel.add((Component)new BorderlessButton((Action)this.addParameterAction));
                buttonPanel.add((Component)new BorderlessButton((Action)this.allInOneRemoveAction));
            }
            JPanel tablePanel = new JPanel(new BorderLayout());
            tablePanel.add((Component)new JScrollPane(this.allInOneTable), "Center");
            if (this.isShowHideParameterUiCheckbox()) {
                tablePanel.add((Component)this.hideParameterUiCheckbox, "North");
            }
            JPanel headerPanel = new JPanel();
            headerPanel.setLayout(new BorderLayout());
            headerPanel.add((Component)this.title, "West");
            headerPanel.add((Component)buttonPanel, "East");
            JPanel centralPanel = new JPanel();
            centralPanel.setLayout(new BorderLayout());
            centralPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
            centralPanel.add((Component)headerPanel, "North");
            centralPanel.add((Component)tablePanel, "Center");
            this.add((Component)centralPanel, "Center");
        } else {
            JPanel systemTablePanel = new JPanel(new BorderLayout());
            systemTablePanel.add((Component)new JScrollPane(this.systemParameterTable), "Center");
            systemTablePanel.add((Component)this.createButtonPanel(null, this.isShowHideParameterUiCheckbox()), "North");
            systemTablePanel.add((Component)this.createAdvancedParameterPanel(), "South");
            JPanel predefinedTablePanel = new JPanel(new BorderLayout());
            predefinedTablePanel.add((Component)new JScrollPane(this.predefinedParameterTable), "Center");
            predefinedTablePanel.add((Component)this.createButtonPanel(null, false), "North");
            JPanel manualTablePanel = new JPanel(new BorderLayout());
            manualTablePanel.add((Component)new JScrollPane(this.manualParameterTable), "Center");
            manualTablePanel.add((Component)this.createButtonPanel(this.manualParameterRemoveAction, false), "North");
            JTabbedPane tabbedPane = new JTabbedPane();
            tabbedPane.addTab(Messages.getString("DrillDownParameterTable.Tab.Report", new Object[0]), predefinedTablePanel);
            tabbedPane.addTab(Messages.getString("DrillDownParameterTable.Tab.System", new Object[0]), systemTablePanel);
            tabbedPane.addTab(Messages.getString("DrillDownParameterTable.Tab.Manual", new Object[0]), manualTablePanel);
            this.add((Component)tabbedPane, "Center");
        }
    }

    private JPanel createAdvancedParameterPanel() {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(2));
        buttonPanel.add(new JButton(this.advancedEditorAction));
        return buttonPanel;
    }

    private JPanel createButtonPanel(Action removeAction, boolean addHideParamUiCheckbox) {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(2));
        if (this.isShowRefreshButton()) {
            buttonPanel.add((Component)new BorderlessButton((Action)this.refreshParameterAction));
            if (removeAction != null) {
                buttonPanel.add(Box.createHorizontalStrut(10));
            }
        }
        if (removeAction != null) {
            buttonPanel.add((Component)new BorderlessButton((Action)this.addParameterAction));
            buttonPanel.add((Component)new BorderlessButton(removeAction));
        }
        if (!addHideParamUiCheckbox) {
            return buttonPanel;
        }
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)buttonPanel, "Center");
        panel.add((Component)this.hideParameterUiCheckbox, "North");
        return panel;
    }

    public void addDrillDownParameterRefreshListener(DrillDownParameterRefreshListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        this.listeners.add(listener);
        this.refreshParameterAction.setEnabled(this.isEnabled() && !this.listeners.isEmpty());
    }

    public void removeDrillDownParameterRefreshListener(DrillDownParameterRefreshListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        this.listeners.remove(listener);
        this.refreshParameterAction.setEnabled(this.isEnabled() && !this.listeners.isEmpty());
    }

    public String getTitle() {
        return this.title.getText();
    }

    public void setTitle(String title) {
        this.title.setText(title);
    }

    public void setReportDesignerContext(ReportDesignerContext context) {
        this.reportDesignerContext = context;
        this.allInOneTable.setReportDesignerContext(context);
        this.systemParameterTable.setReportDesignerContext(context);
        this.manualParameterTable.setReportDesignerContext(context);
        this.predefinedParameterTable.setReportDesignerContext(context);
    }

    public ReportDesignerContext getReportDesignerContext() {
        return this.allInOneTable.getReportDesignerContext();
    }

    public void setDrillDownParameter(DrillDownParameter[] parameter) {
        Object[] oldParameter = this.parameterTableModel.getData();
        this.parameterTableModel.setData(parameter);
        if (!Arrays.equals(oldParameter, parameter)) {
            this.firePropertyChange(DRILL_DOWN_PARAMETER_PROPERTY, oldParameter, parameter);
        }
    }

    public String[] getExtraFields() {
        return this.parameterTableModel.getExtraFields();
    }

    public void setExtraFields(String[] extraFields) {
        this.parameterTableModel.setExtraFields(extraFields);
    }

    public DrillDownParameter[] getDrillDownParameter() {
        return this.parameterTableModel.getData();
    }

    public String[] getFilteredParameterNames() {
        return this.parameterTableModel.getFilteredParameterNames();
    }

    public void setFilteredParameterNames(String[] names) {
        this.parameterTableModel.setFilteredParameterNames(names);
    }

    public boolean isAllowCustomParameter() {
        return this.allowCustomParameter;
    }

    public void setAllowCustomParameter(boolean allowCustomParameter) {
        this.allowCustomParameter = allowCustomParameter;
        this.rebuildUi();
    }

    public boolean isShowRefreshButton() {
        return this.showRefreshButton;
    }

    public void setShowRefreshButton(boolean showRefreshButton) {
        this.showRefreshButton = showRefreshButton;
        this.rebuildUi();
    }

    public void refreshParameterData() {
        this.fireRefreshEvent();
    }

    protected void fireRefreshEvent() {
        if (this.listeners.isEmpty()) {
            return;
        }
        DrillDownParameterRefreshEvent event = new DrillDownParameterRefreshEvent(this, this.getDrillDownParameter());
        for (int i = 0; i < this.listeners.size(); ++i) {
            DrillDownParameterRefreshListener listener = this.listeners.get(i);
            listener.requestParameterRefresh(event);
        }
    }

    public boolean isSingleTabMode() {
        return this.singleTabMode;
    }

    public void setSingleTabMode(boolean singleTabMode) {
        this.singleTabMode = singleTabMode;
        this.rebuildUi();
    }

    public boolean isHideParameterUi() {
        return this.hideParameterUiCheckbox.isSelected();
    }

    public void setHideParameterUi(boolean hideParameterUi) {
        this.hideParameterUiCheckbox.setSelected(hideParameterUi);
    }

    public boolean isShowHideParameterUiCheckbox() {
        return this.hideParameterUiCheckbox.isVisible();
    }

    public void setShowHideParameterUiCheckbox(boolean showHideParameterUiCheckbox) {
        this.hideParameterUiCheckbox.setVisible(showHideParameterUiCheckbox);
        this.rebuildUi();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.hideParameterUiCheckbox.setEnabled(enabled);
        this.allInOneTable.setEnabled(enabled);
        this.systemParameterTable.setEnabled(enabled);
        this.manualParameterTable.setEnabled(enabled);
        this.predefinedParameterTable.setEnabled(enabled);
        this.refreshParameterAction.setEnabled(enabled && !this.listeners.isEmpty());
        this.allInOneRemoveAction.setEnabled(enabled);
        this.manualParameterRemoveAction.setEnabled(enabled);
        this.addParameterAction.setEnabled(enabled);
        this.advancedEditorAction.setEnabled(enabled);
    }

    private class ShowAdvancedEditorAction
    extends AbstractAction {
        private ShowAdvancedEditorAction() {
            this.putValue("Name", Messages.getString("DrillDownParameterTable.Advanced", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Window window = LibSwingUtil.getWindowAncestor((Component)DrillDownParameterTable.this);
            SystemParameterDialog dialog = window instanceof Dialog ? new SystemParameterDialog((Dialog)window, DrillDownParameterTable.this.parameterTableModel, DrillDownParameterTable.this.reportDesignerContext) : (window instanceof Frame ? new SystemParameterDialog((Frame)window, DrillDownParameterTable.this.parameterTableModel, DrillDownParameterTable.this.reportDesignerContext) : new SystemParameterDialog(DrillDownParameterTable.this.parameterTableModel, DrillDownParameterTable.this.reportDesignerContext));
            dialog.showAdvancedEditor();
            dialog.dispose();
        }
    }

    private class HideParamUiSelectionListener
    implements ItemListener {
        private boolean hideParameterUiValue;

        private HideParamUiSelectionListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            boolean oldValue = this.hideParameterUiValue;
            this.hideParameterUiValue = DrillDownParameterTable.this.hideParameterUiCheckbox.isSelected();
            DrillDownParameterTable.this.firePropertyChange(DrillDownParameterTable.HIDE_PARAMETER_UI_PARAMETER_PROPERTY, oldValue, this.hideParameterUiValue);
        }
    }

    private class DrillDownParameterChangeHandler
    implements TableModelListener {
        private DrillDownParameter[] oldData;

        private DrillDownParameterChangeHandler() {
            this.oldData = DrillDownParameterTable.this.parameterTableModel.getData();
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            DrillDownParameter[] newParams = DrillDownParameterTable.this.getDrillDownParameter();
            DrillDownParameterTable.this.firePropertyChange(DrillDownParameterTable.DRILL_DOWN_PARAMETER_PROPERTY, this.oldData, newParams);
            this.oldData = newParams;
        }
    }

    private class RefreshParameterAction
    extends AbstractAction {
        private RefreshParameterAction() {
            this.putValue("SmallIcon", IconLoader.getInstance().getRefreshIcon());
            this.putValue("ShortDescription", Messages.getString("DrillDownParameterTable.RefreshParameter", new Object[0]));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DrillDownParameterTable.this.fireRefreshEvent();
        }
    }

    private class RemoveParameterAction
    extends AbstractAction
    implements ListSelectionListener {
        private GroupedTableModel model;
        private JTable table;

        private RemoveParameterAction(JTable table) {
            this.model = (GroupedTableModel)table.getModel();
            this.table = table;
            this.putValue("SmallIcon", IconLoader.getInstance().getRemoveIcon());
            this.putValue("ShortDescription", Messages.getString("DrillDownParameterTable.RemoveParameter", new Object[0]));
            this.setEnabled(false);
            table.getSelectionModel().addListSelectionListener(this);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            int[] selectedRows = this.table.getSelectedRows();
            for (int i = 0; i < selectedRows.length; ++i) {
                int row = selectedRows[i];
                DrillDownParameter.Type type = DrillDownParameterTable.this.parameterTableModel.getParameterType(this.model.mapToModel(row));
                if (DrillDownParameter.Type.MANUAL != type) continue;
                this.setEnabled(true);
                return;
            }
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!this.isEnabled()) {
                return;
            }
            DrillDownParameter[] data = DrillDownParameterTable.this.parameterTableModel.getGroupedData();
            ListSelectionModel listSelectionModel = this.table.getSelectionModel();
            ArrayList<DrillDownParameter> result = new ArrayList<DrillDownParameter>(data.length);
            for (int i = 0; i < data.length; ++i) {
                DrillDownParameter parameter = data[i];
                if (parameter == null || listSelectionModel.isSelectedIndex(this.model.mapFromModel(i)) && parameter.getType() == DrillDownParameter.Type.MANUAL) continue;
                result.add(data[i]);
            }
            DrillDownParameterTable.this.parameterTableModel.setData(result.toArray(new DrillDownParameter[result.size()]));
        }
    }

    private class AddParameterAction
    extends AbstractAction {
        private AddParameterAction() {
            this.putValue("SmallIcon", IconLoader.getInstance().getAddIcon());
            this.putValue("ShortDescription", Messages.getString("DrillDownParameterTable.AddParameter", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DrillDownParameter[] data = DrillDownParameterTable.this.parameterTableModel.getData();
            DrillDownParameter[] data2 = new DrillDownParameter[data.length + 1];
            System.arraycopy(data, 0, data2, 0, data.length);
            data2[data.length] = new DrillDownParameter(Messages.getString("DrillDownParameterTable.Parameter.DefaultName", new Object[0]));
            data2[data.length].setPosition(data.length);
            DrillDownParameterTable.this.parameterTableModel.setData(data2);
        }
    }
}

