/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.drilldown;

import org.pentaho.reporting.designer.core.editor.drilldown.DrillDownParameterTableModel;
import org.pentaho.reporting.designer.core.editor.drilldown.model.DrillDownParameter;
import org.pentaho.reporting.designer.core.util.table.GroupedMetaTableModel;

public class FilteringParameterTableModel
extends GroupedMetaTableModel {
    private DrillDownParameterTableModel backend;
    private DrillDownParameter.Type filterType;
    private boolean onlyPreferredOptions;

    public FilteringParameterTableModel(DrillDownParameter.Type filterType, DrillDownParameterTableModel backend) {
        this(filterType, backend, false);
    }

    public FilteringParameterTableModel(DrillDownParameter.Type filterType, DrillDownParameterTableModel backend, boolean onlyPreferredOptions) {
        super(backend);
        this.onlyPreferredOptions = onlyPreferredOptions;
        if (filterType == null) {
            throw new NullPointerException();
        }
        if (backend == null) {
            throw new NullPointerException();
        }
        this.filterType = filterType;
        this.backend = backend;
        this.recomputeRowCount();
    }

    @Override
    protected void recomputeRowCount() {
        if (this.backend == null) {
            return;
        }
        super.recomputeRowCount();
    }

    @Override
    public int mapToModel(int row) {
        int size = this.backend.getRowCount();
        int effectiveRow = 0;
        for (int i = 0; i < size; ++i) {
            if (!this.isAcceptedRow(i)) continue;
            if (effectiveRow == row) {
                return i;
            }
            ++effectiveRow;
        }
        throw new IndexOutOfBoundsException("Unable to map row to model: " + row);
    }

    protected boolean isAcceptedRow(int row) {
        DrillDownParameter.Type groupHeader = this.backend.getParameterType(row);
        if (groupHeader == this.filterType) {
            if (this.onlyPreferredOptions) {
                return this.backend.isPreferred(row);
            }
            return true;
        }
        return false;
    }

    @Override
    public int mapFromModel(int row) {
        if (row < 0) {
            return row;
        }
        int size = this.backend.getRowCount();
        int retval = 0;
        for (int i = 0; i < size; ++i) {
            if (!this.isAcceptedRow(i)) continue;
            if (row == i) {
                return retval;
            }
            ++retval;
        }
        return retval;
    }
}

