/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.drilldown;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.util.HashMap;
import java.util.Map;
import org.pentaho.reporting.designer.core.Messages;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.editor.drilldown.HyperlinkEditorPane;
import org.pentaho.reporting.designer.core.editor.format.EditableStyleSheet;
import org.pentaho.reporting.designer.core.util.undo.ElementFormatUndoEntry;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleSheet;
import org.pentaho.reporting.engine.classic.core.style.StyleKey;
import org.pentaho.reporting.libraries.designtime.swing.CommonDialog;

public class HyperlinkEditorDialog
extends CommonDialog {
    private HyperlinkEditorPane hyperlinksPane;

    public HyperlinkEditorDialog() throws HeadlessException {
        this.init();
    }

    public HyperlinkEditorDialog(Frame owner) throws HeadlessException {
        super(owner);
        this.init();
    }

    public HyperlinkEditorDialog(Dialog owner) throws HeadlessException {
        super(owner);
        this.init();
    }

    protected void init() {
        this.setTitle(Messages.getString("HyperlinkEditorDialog.Title", new Object[0]));
        this.hyperlinksPane = new HyperlinkEditorPane();
        super.init();
    }

    protected String getDialogId() {
        return "ReportDesigner.Core.HyperlinkEditor";
    }

    protected Component createContentPane() {
        return this.hyperlinksPane;
    }

    public ElementFormatUndoEntry.EditResult performEdit(ReportDesignerContext designerContext, ElementStyleSheet element, Map<StyleKey, Expression> styleExpressions) {
        if (styleExpressions == null) {
            throw new NullPointerException();
        }
        EditableStyleSheet styleSheet = new EditableStyleSheet();
        styleSheet.copyParentValues(element);
        HashMap<StyleKey, Expression> editableStyleExpressions = new HashMap<StyleKey, Expression>(styleExpressions);
        this.hyperlinksPane.initializeFromStyle(styleSheet, editableStyleExpressions, designerContext);
        if (!this.performEdit()) {
            return null;
        }
        this.hyperlinksPane.commitValues(styleSheet, editableStyleExpressions);
        return new ElementFormatUndoEntry.EditResult(styleSheet, editableStyleExpressions);
    }
}

