/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.drilldown.basic;

import java.awt.Dimension;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.designer.core.util.FormulaEditorPanel;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.dom.Element;
import org.pentaho.ui.xul.swing.AbstractSwingContainer;
import org.pentaho.ui.xul.swing.tags.SwingListitem;
import org.pentaho.ui.xul.util.TextType;

public class XulFormulaTextField
extends AbstractSwingContainer
implements XulComponent {
    private static final Log logger = LogFactory.getLog(XulFormulaTextField.class);
    private FormulaEditorPanel textField;
    boolean disabled;
    private String value;
    private boolean readonly;
    private TextType type;
    private String onInput;
    private int maxlength;
    private String oldValue;

    public XulFormulaTextField(Element self, XulComponent parent, XulDomContainer domContainer, String tagName) {
        super(tagName);
        this.setManagedObject(null);
        this.disabled = false;
        this.value = "";
        this.type = TextType.NORMAL;
        this.readonly = false;
        this.maxlength = -1;
        this.oldValue = null;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String text) {
        String oldVal = this.value;
        if (this.textField != null && ObjectUtilities.equal((Object)text, (Object)this.textField.getFormula())) {
            return;
        }
        if (this.textField != null) {
            this.textField.setFormula(text);
        }
        this.value = text;
        if (text != null || oldVal != null) {
            this.changeSupport.firePropertyChange("value", oldVal, text);
        }
    }

    public void layout() {
        ArrayList<String> list = new ArrayList<String>();
        for (Element comp : this.getChildNodes()) {
            if (!(comp instanceof SwingListitem)) continue;
            SwingListitem swingListitem = (SwingListitem)comp;
            list.add((String)swingListitem.getValue());
            logger.info((Object)"added tag to formula editor");
        }
        FormulaEditorPanel panel = (FormulaEditorPanel)this.getManagedObject();
        panel.setTags(list.toArray(new String[list.size()]));
    }

    public int getMaxlength() {
        return this.maxlength;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean dis) {
        boolean oldValue = this.disabled;
        this.disabled = dis;
        if (this.textField != null) {
            this.textField.setEnabled(!dis);
        }
        this.changeSupport.firePropertyChange("disabled", oldValue, dis);
    }

    public void setMaxlength(int length) {
        this.maxlength = length;
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public void setReadonly(boolean readOnly) {
        this.readonly = readOnly;
    }

    public String getType() {
        if (this.type == null) {
            return null;
        }
        return this.type.toString();
    }

    public void selectAll() {
        this.textField.selectAll();
    }

    public void setFocus() {
    }

    public Object getTextControl() {
        return this.getManagedObject();
    }

    public Object getManagedObject() {
        if (super.getManagedObject() == null) {
            this.textField = new FormulaEditorPanel();
            this.textField.setFormula(this.value);
            this.textField.setPreferredSize(new Dimension(150, this.textField.getPreferredSize().height));
            this.textField.setMinimumSize(new Dimension(this.textField.getPreferredSize().width, this.textField.getPreferredSize().height));
            this.textField.setEditable(!this.readonly);
            this.textField.setEnabled(!this.disabled);
            this.textField.addFormulaKeyListener(new KeyInputHandler());
            this.textField.addPropertyChangeListener("formula", new ChangeEventForwarder());
            this.setManagedObject(this.textField);
        }
        this.textField.setToolTipText(this.getTooltiptext());
        return super.getManagedObject();
    }

    public void setOninput(String method) {
        if (this.textField != null) {
            this.onInput = method;
            this.textField.addFormulaKeyListener(new MethodInvokeHandler(method));
        } else {
            this.onInput = method;
        }
    }

    public String getOninput() {
        return this.onInput;
    }

    private class ChangeEventForwarder
    implements PropertyChangeListener {
        private ChangeEventForwarder() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            XulFormulaTextField.this.value = XulFormulaTextField.this.textField.getFormula();
            XulFormulaTextField.this.changeSupport.firePropertyChange("value", evt.getOldValue(), evt.getNewValue());
        }
    }

    private class MethodInvokeHandler
    extends KeyAdapter {
        private final String method;

        public MethodInvokeHandler(String method) {
            this.method = method;
        }

        @Override
        public void keyReleased(KeyEvent e) {
            XulFormulaTextField.this.invoke(this.method);
        }
    }

    private class KeyInputHandler
    implements KeyListener {
        private KeyInputHandler() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            XulFormulaTextField.this.oldValue = XulFormulaTextField.this.textField.getFormula();
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (XulFormulaTextField.this.oldValue != null && !XulFormulaTextField.this.oldValue.equals(XulFormulaTextField.this.textField.getFormula())) {
                XulFormulaTextField.this.changeSupport.firePropertyChange("value", XulFormulaTextField.this.oldValue, XulFormulaTextField.this.getValue());
                XulFormulaTextField.this.oldValue = XulFormulaTextField.this.textField.getFormula();
            } else if (XulFormulaTextField.this.oldValue == null) {
                XulFormulaTextField.this.oldValue = XulFormulaTextField.this.textField.getFormula();
            } else {
                logger.debug((Object)"Special key pressed, ignoring");
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }
    }
}

