/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.drilldown.model;

import java.io.Serializable;
import java.util.Locale;
import org.pentaho.reporting.engine.classic.core.metadata.MaturityLevel;
import org.pentaho.reporting.engine.classic.core.metadata.MetaData;

public class DrillDownParameter
implements MetaData,
Serializable {
    private String name;
    private String formulaFragment;
    private Type type;
    private int position;
    private boolean preferred;
    private boolean expert;
    private int compatibilityLevel;

    public DrillDownParameter(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        this.compatibilityLevel = -1;
        this.preferred = true;
        this.name = name;
        this.type = Type.MANUAL;
    }

    public DrillDownParameter(String name, String formulaFragment) {
        this(name);
        this.formulaFragment = formulaFragment;
        this.type = Type.MANUAL;
    }

    public DrillDownParameter(String name, String formulaFragment, Type type, boolean expert, boolean hidden) {
        this(name, formulaFragment);
        if (type == null) {
            throw new NullPointerException();
        }
        this.expert = expert;
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        this.name = name;
    }

    public String getFormulaFragment() {
        return this.formulaFragment;
    }

    public void setFormulaFragment(String formulaFragment) {
        this.formulaFragment = formulaFragment;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        if (type == null) {
            throw new NullPointerException();
        }
        this.type = type;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DrillDownParameter that = (DrillDownParameter)o;
        if (this.position != that.position) {
            return false;
        }
        if (this.formulaFragment != null ? !this.formulaFragment.equals(that.formulaFragment) : that.formulaFragment != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        return this.type == that.type;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.formulaFragment != null ? this.formulaFragment.hashCode() : 0);
        result = 31 * result + this.type.hashCode();
        result = 31 * result + this.position;
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("DrillDownParameter");
        sb.append("{name='").append(this.name).append('\'');
        sb.append(", formulaFragment='").append(this.formulaFragment).append('\'');
        sb.append(", type=").append((Object)this.type);
        sb.append(", position=").append(this.position);
        sb.append('}');
        return sb.toString();
    }

    public void setPreferred(boolean preferred) {
        this.preferred = preferred;
    }

    public boolean isPreferred() {
        return this.preferred;
    }

    public String getDisplayName(Locale locale) {
        return this.name;
    }

    public String getMetaAttribute(String attributeName, Locale locale) {
        return null;
    }

    public String getGrouping(Locale locale) {
        return this.type.toString();
    }

    public int getGroupingOrdinal(Locale locale) {
        return this.type.ordinal();
    }

    public int getItemOrdinal(Locale locale) {
        return this.position;
    }

    public String getDeprecationMessage(Locale locale) {
        return null;
    }

    public String getDescription(Locale locale) {
        return null;
    }

    public boolean isDeprecated() {
        return false;
    }

    public void setExpert(boolean expert) {
        this.expert = expert;
    }

    public boolean isExpert() {
        return this.expert;
    }

    public boolean isHidden() {
        return false;
    }

    public MaturityLevel getFeatureMaturityLevel() {
        return MaturityLevel.Production;
    }

    public boolean isExperimental() {
        return false;
    }

    public int getCompatibilityLevel() {
        return this.compatibilityLevel;
    }

    public String getKeyPrefix() {
        return null;
    }

    public String getBundleLocation() {
        return null;
    }

    public static enum Type {
        PREDEFINED,
        SYSTEM,
        MANUAL;

    }
}

