/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.format;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.pentaho.reporting.designer.core.Messages;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.util.ExpressionEditorPane;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.libraries.designtime.swing.CommonDialog;

public class ConditionalVisibilityDialog
extends CommonDialog {
    private ExpressionEditorPane editorPane;

    public ConditionalVisibilityDialog() throws HeadlessException {
        this.init();
    }

    public ConditionalVisibilityDialog(Frame owner) throws HeadlessException {
        super(owner);
        this.init();
    }

    public ConditionalVisibilityDialog(Dialog owner) throws HeadlessException {
        super(owner);
        this.init();
    }

    protected void init() {
        this.setTitle(Messages.getString("ConditionalVisibilityDialog.HideObject", new Object[0]));
        this.setDefaultCloseOperation(2);
        this.setLayout(new BorderLayout());
        this.editorPane = new ExpressionEditorPane();
        this.setModal(true);
        super.init();
    }

    protected String getDialogId() {
        return "ReportDesigner.Core.ConditionalVisibility";
    }

    protected Component createContentPane() {
        JPanel floatingPanel = new JPanel();
        floatingPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.anchor = 17;
        floatingPanel.add((Component)new JLabel(Messages.getString("ConditionalVisibilityDialog.Condition", new Object[0])), gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 5, 5, 5);
        floatingPanel.add((Component)this.editorPane, gbc);
        return floatingPanel;
    }

    public Expression performEdit(Expression expression) {
        this.editorPane.setValue(expression);
        if (!this.performEdit()) {
            return null;
        }
        return this.editorPane.getValue();
    }

    public ReportDesignerContext getReportDesignerContext() {
        return this.editorPane.getReportDesignerContext();
    }

    public void setReportDesignerContext(ReportDesignerContext reportDesignerContext) {
        this.editorPane.setReportDesignerContext(reportDesignerContext);
    }
}

