/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.format;

import java.awt.Component;
import java.awt.GridBagLayout;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.pentaho.reporting.designer.core.Messages;
import org.pentaho.reporting.designer.core.editor.format.FontPreviewPane;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleSheet;
import org.pentaho.reporting.engine.classic.core.style.FontSmooth;
import org.pentaho.reporting.engine.classic.core.style.TextStyleKeys;
import org.pentaho.reporting.libraries.designtime.swing.BasicFontPropertiesPane;
import org.pentaho.reporting.libraries.designtime.swing.KeyedComboBoxModel;

public class FontPropertiesPane
extends BasicFontPropertiesPane {
    private KeyedComboBoxModel fontSmoothModel;
    private FontPreviewPane previewPane;

    public FontPropertiesPane() {
        this.setLayout(new GridBagLayout());
        this.fontSmoothModel = this.createFontSmoothModel();
        this.previewPane = new FontPreviewPane();
        this.init();
    }

    protected JComponent createPreviewPane() {
        return this.previewPane;
    }

    protected Component createAliasPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(new JLabel(Messages.getString("FontPropertiesPane.AntiAliasing", new Object[0])));
        panel.add(new JComboBox(this.fontSmoothModel));
        return panel;
    }

    private KeyedComboBoxModel createFontSmoothModel() {
        KeyedComboBoxModel model = new KeyedComboBoxModel();
        model.add((Object)FontSmooth.NEVER, (Object)Messages.getString("FontPropertiesPane.Never", new Object[0]));
        model.add((Object)FontSmooth.AUTO, (Object)Messages.getString("FontPropertiesPane.Automatic", new Object[0]));
        model.add((Object)FontSmooth.ALWAYS, (Object)Messages.getString("FontPropertiesPane.Always", new Object[0]));
        return model;
    }

    public void initializeFromStyle(ElementStyleSheet style) {
        this.setFontFamily((String)style.getStyleProperty(TextStyleKeys.FONT));
        this.setFontSize(style.getIntStyleProperty(TextStyleKeys.FONTSIZE, 10));
        int computedStyle = 0;
        if (style.getBooleanStyleProperty(TextStyleKeys.BOLD)) {
            computedStyle |= 1;
        }
        if (style.getBooleanStyleProperty(TextStyleKeys.ITALIC)) {
            computedStyle |= 2;
        }
        this.setFontStyle(computedStyle);
        this.setUnderlined(style.getBooleanStyleProperty(TextStyleKeys.UNDERLINED));
        this.setStrikeThrough(style.getBooleanStyleProperty(TextStyleKeys.STRIKETHROUGH));
        this.fontSmoothModel.setSelectedKey(style.getStyleProperty(TextStyleKeys.FONT_SMOOTH));
    }

    public void commitValues(ElementStyleSheet styleSheet) {
        styleSheet.setStyleProperty(TextStyleKeys.FONT, (Object)this.getFontFamily());
        try {
            styleSheet.setStyleProperty(TextStyleKeys.FONTSIZE, (Object)this.getFontSize());
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        int style = this.getFontStyle();
        styleSheet.setStyleProperty(TextStyleKeys.BOLD, (Object)((style & 1) == 1 ? 1 : 0));
        styleSheet.setStyleProperty(TextStyleKeys.ITALIC, (Object)((style & 2) == 2 ? 1 : 0));
        styleSheet.setBooleanStyleProperty(TextStyleKeys.UNDERLINED, this.isUnderlined());
        styleSheet.setBooleanStyleProperty(TextStyleKeys.STRIKETHROUGH, this.isStrikeThrough());
        styleSheet.setStyleProperty(TextStyleKeys.FONT_SMOOTH, this.fontSmoothModel.getSelectedKey());
    }
}

