/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.format;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.ComboBoxEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import org.pentaho.reporting.designer.core.Messages;
import org.pentaho.reporting.designer.core.editor.format.SelectCustomColorAction;
import org.pentaho.reporting.engine.classic.core.function.RowBandingFunction;
import org.pentaho.reporting.libraries.designtime.swing.ColorCellRenderer;
import org.pentaho.reporting.libraries.designtime.swing.ColorComboBox;
import org.pentaho.reporting.libraries.designtime.swing.CommonDialog;
import org.pentaho.reporting.libraries.designtime.swing.KeyedComboBoxModel;
import org.pentaho.reporting.libraries.designtime.swing.ValuePassThroughCellEditor;

public class RowBandingDialog
extends CommonDialog {
    private JTextField elementNameField;
    private ColorComboBox visibleColorBox;
    private ColorComboBox invisibleColorBox;
    private KeyedComboBoxModel<Boolean, String> pageStateModel;
    private KeyedComboBoxModel<Boolean, String> initialStateModel;

    public RowBandingDialog() {
        this.init();
    }

    public RowBandingDialog(Frame owner) {
        super(owner);
        this.init();
    }

    public RowBandingDialog(Dialog owner) {
        super(owner);
        this.init();
    }

    protected String getDialogId() {
        return "ReportDesigner.Core.RowBanding";
    }

    protected Component createContentPane() {
        this.setTitle(Messages.getString("RowBandingDialog.RowBanding", new Object[0]));
        this.visibleColorBox = new ColorComboBox();
        this.visibleColorBox.setEditable(true);
        this.visibleColorBox.setEditor((ComboBoxEditor)new ValuePassThroughCellEditor((JComboBox)this.visibleColorBox, (ListCellRenderer)new ColorCellRenderer()));
        this.invisibleColorBox = new ColorComboBox();
        this.invisibleColorBox.setEditable(true);
        this.invisibleColorBox.setEditor((ComboBoxEditor)new ValuePassThroughCellEditor((JComboBox)this.invisibleColorBox, (ListCellRenderer)new ColorCellRenderer()));
        this.elementNameField = new JTextField();
        this.elementNameField.setColumns(40);
        this.initialStateModel = this.createInitialStateModel();
        this.pageStateModel = this.createNewPageStateModel();
        JComboBox initialStateBox = new JComboBox(this.initialStateModel);
        JComboBox newPageStateBox = new JComboBox(this.pageStateModel);
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        contentPanel.add((Component)new JLabel(Messages.getString("RowBandingDialog.VisibleColor", new Object[0])), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.fill = 2;
        contentPanel.add((Component)this.visibleColorBox, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(5, 5, 0, 5);
        contentPanel.add((Component)new JButton(new SelectCustomColorAction((JComboBox)this.visibleColorBox)), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        contentPanel.add((Component)new JLabel(Messages.getString("RowBandingDialog.InvisibleColor", new Object[0])), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.fill = 2;
        contentPanel.add((Component)this.invisibleColorBox, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.anchor = 17;
        gbc.insets = new Insets(5, 5, 0, 5);
        contentPanel.add((Component)new JButton(new SelectCustomColorAction((JComboBox)this.invisibleColorBox)), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        contentPanel.add((Component)new JLabel(Messages.getString("RowBandingDialog.Element", new Object[0])), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.fill = 2;
        contentPanel.add((Component)this.elementNameField, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        contentPanel.add((Component)new JLabel(Messages.getString("RowBandingDialog.StateOnNewGroup", new Object[0])), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.fill = 2;
        contentPanel.add(initialStateBox, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 4;
        contentPanel.add((Component)new JLabel(Messages.getString("RowBandingDialog.StateOnNewPage", new Object[0])), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 4;
        gbc.fill = 2;
        contentPanel.add(newPageStateBox, gbc);
        return contentPanel;
    }

    public boolean performEdit(RowBandingFunction function) {
        if (function == null) {
            throw new NullPointerException();
        }
        String element = function.getElement();
        if (element != null) {
            this.elementNameField.setText(element);
        } else {
            this.elementNameField.setText("");
        }
        this.initialStateModel.setSelectedKey((Object)function.getInitialState());
        this.pageStateModel.setSelectedKey((Object)function.getNewPageState());
        this.invisibleColorBox.setValueFromModel(function.getInvisibleBackground());
        this.visibleColorBox.setValueFromModel(function.getVisibleBackground());
        if (!super.performEdit()) {
            return false;
        }
        String elementName = this.elementNameField.getText();
        if (elementName.length() == 0) {
            function.setElement(null);
        } else {
            function.setElement(elementName);
        }
        function.setInitialState(Boolean.TRUE.equals(this.initialStateModel.getSelectedKey()));
        function.setNewPageState((Boolean)this.pageStateModel.getSelectedKey());
        function.setInvisibleBackground(this.invisibleColorBox.getValueFromModel());
        function.setVisibleBackground(this.visibleColorBox.getValueFromModel());
        return true;
    }

    private KeyedComboBoxModel<Boolean, String> createNewPageStateModel() {
        KeyedComboBoxModel model = new KeyedComboBoxModel();
        model.add(null, (Object)Messages.getString("RowBandingDialog.SameAsInitialState", new Object[0]));
        model.add((Object)Boolean.TRUE, (Object)Messages.getString("RowBandingDialog.Visible", new Object[0]));
        model.add((Object)Boolean.FALSE, (Object)Messages.getString("RowBandingDialog.Invisible", new Object[0]));
        return model;
    }

    private KeyedComboBoxModel<Boolean, String> createInitialStateModel() {
        KeyedComboBoxModel model = new KeyedComboBoxModel();
        model.add((Object)Boolean.TRUE, (Object)Messages.getString("RowBandingDialog.Visible", new Object[0]));
        model.add((Object)Boolean.FALSE, (Object)Messages.getString("RowBandingDialog.Invisible", new Object[0]));
        return model;
    }
}

