/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.groups;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;
import org.pentaho.reporting.designer.core.Messages;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.editor.groups.EditGroupDetailsDialog;
import org.pentaho.reporting.designer.core.editor.groups.EditGroupsUndoEntry;
import org.pentaho.reporting.designer.core.editor.groups.GroupDataEntry;
import org.pentaho.reporting.designer.core.editor.groups.GroupDataEntryCellEditor;
import org.pentaho.reporting.designer.core.editor.groups.GroupDataEntryCellRenderer;
import org.pentaho.reporting.designer.core.editor.groups.GroupDataTableModel;
import org.pentaho.reporting.designer.core.util.IconLoader;
import org.pentaho.reporting.designer.core.util.undo.EditGroupUndoEntry;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.RelationalGroup;
import org.pentaho.reporting.libraries.designtime.swing.BorderlessButton;
import org.pentaho.reporting.libraries.designtime.swing.CommonDialog;
import org.pentaho.reporting.libraries.designtime.swing.bulk.BulkDataProvider;
import org.pentaho.reporting.libraries.designtime.swing.bulk.SortBulkDownAction;
import org.pentaho.reporting.libraries.designtime.swing.bulk.SortBulkUpAction;

public class EditGroupsDialog
extends CommonDialog {
    private JTable table;
    private GroupDataTableModel tableModel;
    private ReportDocumentContext reportRenderContext;
    private GroupDataEntryCellEditor groupDataEntryCellEditor;

    public EditGroupsDialog() throws HeadlessException {
        this.init();
    }

    public EditGroupsDialog(Frame owner) throws HeadlessException {
        super(owner);
        this.init();
    }

    public EditGroupsDialog(Dialog owner) throws HeadlessException {
        super(owner);
        this.init();
    }

    protected void init() {
        this.setTitle(Messages.getString("EditGroupsDialog.EditGroup", new Object[0]));
        this.setModal(true);
        this.groupDataEntryCellEditor = new GroupDataEntryCellEditor();
        this.tableModel = new GroupDataTableModel();
        super.init();
    }

    protected String getDialogId() {
        return "ReportDesigner.Core.EditGroups";
    }

    protected Component createContentPane() {
        this.table = new JTable(this.tableModel);
        this.table.setDefaultEditor(GroupDataEntry.class, this.groupDataEntryCellEditor);
        this.table.setDefaultRenderer(GroupDataEntry.class, new GroupDataEntryCellRenderer());
        ListSelectionModel selectionModel = this.table.getSelectionModel();
        AddGroupAction addGroupAction = new AddGroupAction(this.tableModel);
        RemoveGroupAction removeGroupAction = new RemoveGroupAction(this.tableModel, selectionModel);
        EditGroupAction editGroupAction = new EditGroupAction(this.tableModel, selectionModel);
        SortBulkUpAction sortUpAction = new SortBulkUpAction((BulkDataProvider)this.tableModel, selectionModel, this.table);
        SortBulkDownAction sortDownAction = new SortBulkDownAction((BulkDataProvider)this.tableModel, selectionModel, this.table);
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setLayout(new FlowLayout(2));
        buttonsPanel.add((Component)new BorderlessButton((Action)sortUpAction));
        buttonsPanel.add((Component)new BorderlessButton((Action)sortDownAction));
        buttonsPanel.add(Box.createHorizontalStrut(20));
        buttonsPanel.add((Component)new BorderlessButton((Action)editGroupAction));
        buttonsPanel.add((Component)new BorderlessButton((Action)addGroupAction));
        buttonsPanel.add((Component)new BorderlessButton((Action)removeGroupAction));
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)new JScrollPane(this.table), "Center");
        panel.add((Component)buttonsPanel, "North");
        return panel;
    }

    protected ReportDocumentContext getReportRenderContext() {
        return this.reportRenderContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected GroupDataEntry[] editGroups(ReportDocumentContext reportRenderContext, GroupDataEntry[] groupData) {
        if (reportRenderContext == null) {
            throw new NullPointerException();
        }
        this.reportRenderContext = reportRenderContext;
        this.groupDataEntryCellEditor.setReportContext(reportRenderContext);
        try {
            this.tableModel.clear();
            for (int i = 0; i < groupData.length; ++i) {
                GroupDataEntry dataEntry = groupData[i];
                this.tableModel.add(dataEntry);
            }
            if (!this.performEdit()) {
                GroupDataEntry[] i = null;
                return i;
            }
            TableCellEditor cellEditor = this.table.getCellEditor();
            if (cellEditor != null) {
                cellEditor.stopCellEditing();
            }
            GroupDataEntry[] retval = new GroupDataEntry[this.tableModel.getSize()];
            for (int i = 0; i < retval.length; ++i) {
                retval[i] = this.tableModel.get(i);
            }
            GroupDataEntry[] groupDataEntryArray = retval;
            return groupDataEntryArray;
        }
        finally {
            this.reportRenderContext = null;
            this.groupDataEntryCellEditor.setReportContext(null);
        }
    }

    public boolean editGroups(ReportDocumentContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        AbstractReportDefinition abstractReportDefinition = context.getReportDefinition();
        GroupDataEntry[] oldEntries = EditGroupsUndoEntry.buildGroupData(abstractReportDefinition);
        GroupDataEntry[] newEntries = this.editGroups(context, oldEntries);
        if (newEntries == null) {
            return false;
        }
        EditGroupsUndoEntry.applyGroupData(abstractReportDefinition, newEntries);
        return true;
    }

    private class EditGroupAction
    extends AbstractAction
    implements ListSelectionListener {
        private ListSelectionModel selectionModel;
        private GroupDataTableModel tableModel;

        private EditGroupAction(GroupDataTableModel tableModel, ListSelectionModel selectionModel) {
            this.tableModel = tableModel;
            this.putValue("ShortDescription", Messages.getString("EditGroupsDialog.EditGroup", new Object[0]));
            this.putValue("SmallIcon", IconLoader.getInstance().getEditIcon());
            this.selectionModel = selectionModel;
            this.selectionModel.addListSelectionListener(this);
            this.setEnabled(!this.selectionModel.isSelectionEmpty());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int index;
            TableCellEditor cellEditor = EditGroupsDialog.this.table.getCellEditor();
            if (cellEditor != null) {
                cellEditor.stopCellEditing();
            }
            if ((index = this.selectionModel.getLeadSelectionIndex()) == -1) {
                return;
            }
            EditGroupDetailsDialog dialog = new EditGroupDetailsDialog((Dialog)((Object)EditGroupsDialog.this));
            GroupDataEntry groupDataEntry = this.tableModel.get(index);
            if (dialog.editGroupData(groupDataEntry.getName(), groupDataEntry.getFields(), EditGroupsDialog.this.getReportRenderContext())) {
                this.tableModel.update(index, new GroupDataEntry(null, dialog.getGroupName(), dialog.getFields()));
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.setEnabled(!this.selectionModel.isSelectionEmpty());
        }
    }

    private class RemoveGroupAction
    extends AbstractAction
    implements ListSelectionListener {
        private ListSelectionModel selectionModel;
        private GroupDataTableModel tableModel;

        private RemoveGroupAction(GroupDataTableModel tableModel, ListSelectionModel selectionModel) {
            this.tableModel = tableModel;
            this.putValue("ShortDescription", Messages.getString("EditGroupsDialog.RemoveGroup", new Object[0]));
            this.putValue("SmallIcon", IconLoader.getInstance().getRemoveIcon());
            this.selectionModel = selectionModel;
            this.selectionModel.addListSelectionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int i;
            TableCellEditor cellEditor = EditGroupsDialog.this.table.getCellEditor();
            if (cellEditor != null) {
                cellEditor.stopCellEditing();
            }
            int maxIdx = this.selectionModel.getMaxSelectionIndex();
            ArrayList<GroupDataEntry> list = new ArrayList<GroupDataEntry>();
            for (i = this.selectionModel.getMinSelectionIndex(); i <= maxIdx; ++i) {
                if (!this.selectionModel.isSelectedIndex(i)) continue;
                list.add(this.tableModel.get(i));
            }
            for (i = 0; i < list.size(); ++i) {
                GroupDataEntry dataEntry = (GroupDataEntry)list.get(i);
                this.tableModel.remove(dataEntry);
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.setEnabled(!this.selectionModel.isSelectionEmpty());
        }
    }

    private class AddGroupAction
    extends AbstractAction {
        private GroupDataTableModel tableModel;

        private AddGroupAction(GroupDataTableModel tableModel) {
            this.tableModel = tableModel;
            this.putValue("ShortDescription", Messages.getString("EditGroupsDialog.AddGroup", new Object[0]));
            this.putValue("SmallIcon", IconLoader.getInstance().getAddIcon());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RelationalGroup group;
            EditGroupDetailsDialog dialog;
            EditGroupUndoEntry groupUndoEntry;
            TableCellEditor cellEditor = EditGroupsDialog.this.table.getCellEditor();
            if (cellEditor != null) {
                cellEditor.stopCellEditing();
            }
            if ((groupUndoEntry = (dialog = new EditGroupDetailsDialog((Dialog)((Object)EditGroupsDialog.this))).editGroup(group = new RelationalGroup(), EditGroupsDialog.this.getReportRenderContext(), true)) != null) {
                this.tableModel.add(new GroupDataEntry(null, groupUndoEntry.getNewName(), groupUndoEntry.getNewFields()));
            }
        }
    }
}

