/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.palette;

import java.awt.Image;
import java.awt.Point;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.image.BufferedImage;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.actions.elements.InsertElementAction;
import org.pentaho.reporting.designer.core.util.dnd.ElementMetaDataTransferable;
import org.pentaho.reporting.engine.classic.core.event.ReportModelEvent;
import org.pentaho.reporting.engine.classic.core.metadata.ElementMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ElementTypeRegistry;

public class PaletteButton
extends JButton
implements DragGestureListener {
    private String elementName;
    private static final BufferedImage EMPTY_DRAG_IMAGE = new BufferedImage(1, 1, 2);

    public PaletteButton(ElementMetaData elementMetaData, ReportDesignerContext context) {
        if (elementMetaData == null) {
            throw new NullPointerException();
        }
        this.elementName = elementMetaData.getName();
        this.putClientProperty("hideActionText", Boolean.TRUE);
        DragSource dragSource = new DragSource();
        dragSource.createDefaultDragGestureRecognizer(this, 1, this);
        AlwaysActiveInsertElementAction action = new AlwaysActiveInsertElementAction(elementMetaData);
        action.setReportDesignerContext(context);
        this.setAction(action);
        Image icon = elementMetaData.getIcon(Locale.getDefault(), 1);
        if (icon != null) {
            this.setIcon(new ImageIcon(icon));
        } else {
            this.setText(elementMetaData.getDisplayName(Locale.getDefault()));
        }
        this.setToolTipText(elementMetaData.getDescription(Locale.getDefault()));
        this.setFocusable(false);
        this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent anEvent) {
        ElementMetaData elementMetaData = ElementTypeRegistry.getInstance().getElementType(this.elementName);
        ElementMetaDataTransferable transferable = new ElementMetaDataTransferable(elementMetaData);
        anEvent.startDrag(DragSource.DefaultCopyNoDrop, EMPTY_DRAG_IMAGE, new Point(), transferable, null);
        ButtonModel model = this.getModel();
        model.setArmed(false);
        model.setPressed(false);
    }

    private static class AlwaysActiveInsertElementAction
    extends InsertElementAction {
        private AlwaysActiveInsertElementAction(ElementMetaData metaData) {
            super(metaData);
        }

        @Override
        protected void selectedElementPropertiesChanged(ReportModelEvent event) {
        }

        @Override
        protected void updateSelection() {
            this.setEnabled(this.getActiveContext() != null);
        }
    }
}

