/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.parameters;

import java.awt.Component;
import java.awt.event.ActionListener;
import javax.swing.ComboBoxEditor;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.EventListenerList;
import org.pentaho.reporting.designer.core.editor.parameters.ClassListCellRenderer;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class ClassComboBoxEditor
implements ComboBoxEditor {
    private EventListenerList listenerList = new EventListenerList();
    private JTextField textField;
    private Class value;
    private Class[] classes;

    public ClassComboBoxEditor() {
        this(false, null);
    }

    public ClassComboBoxEditor(boolean withBorder, Class[] classes) {
        this.textField = withBorder ? new JTextField() : new BorderlessTextField();
        this.textField.setDisabledTextColor(this.textField.getForeground());
        this.classes = classes;
    }

    @Override
    public Component getEditorComponent() {
        return this.textField;
    }

    @Override
    public void setItem(Object anObject) {
        if (anObject == null) {
            this.value = null;
            this.textField.setText(null);
        } else {
            Class fe;
            this.value = fe = (Class)anObject;
            this.textField.setText(ClassListCellRenderer.getSimpleName(fe));
        }
    }

    @Override
    public Object getItem() {
        String inputVal = this.textField.getText();
        Class inputClass = this.findClass(inputVal);
        try {
            ClassLoader loader = ObjectUtilities.getClassLoader(ClassComboBoxEditor.class);
            return Class.forName(inputClass != null ? inputClass.getName() : inputVal, false, loader);
        }
        catch (ClassNotFoundException e) {
            if (this.value != null) {
                this.textField.setText(this.value.getName());
            } else {
                this.textField.setText(null);
            }
            return this.value;
        }
    }

    @Override
    public void selectAll() {
        this.textField.requestFocus();
        this.textField.select(0, this.textField.getText().length());
    }

    @Override
    public void addActionListener(ActionListener l) {
        this.listenerList.add(ActionListener.class, l);
    }

    @Override
    public void removeActionListener(ActionListener l) {
        this.listenerList.remove(ActionListener.class, l);
    }

    private Class findClass(String className) {
        if (this.classes == null) {
            return null;
        }
        if (className == null) {
            return null;
        }
        for (Class aClass : this.classes) {
            String simpleName = ClassListCellRenderer.getSimpleName(aClass);
            if (!className.equals(simpleName) && !className.equals(aClass.getName())) continue;
            return aClass;
        }
        return null;
    }

    private static class BorderlessTextField
    extends JTextField {
        private BorderlessTextField() {
        }

        @Override
        public void setText(String s) {
            if (this.getText().equals(s)) {
                return;
            }
            super.setText(s);
        }

        @Override
        public void setBorder(Border b) {
        }
    }
}

