/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.parameters;

import javax.swing.DefaultComboBoxModel;
import org.pentaho.reporting.designer.core.editor.parameters.Messages;

public class ParameterType {
    private String displayName;
    private boolean multiSelection;
    private boolean queryOptional;
    private String internalName;

    public ParameterType(String internalName, String displayName, boolean multiSelection, boolean queryOptional) {
        this.internalName = internalName;
        this.displayName = displayName;
        this.multiSelection = multiSelection;
        this.queryOptional = queryOptional;
    }

    public boolean isHasVisibleItems() {
        return "list".equals(this.internalName);
    }

    public boolean isQueryOptional() {
        return this.queryOptional;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public boolean isMultiSelection() {
        return this.multiSelection;
    }

    public String getInternalName() {
        return this.internalName;
    }

    public String toString() {
        return this.displayName;
    }

    public String getLayout() {
        if ("togglebutton".equals(this.internalName)) {
            return "horizontal";
        }
        if ("radio".equals(this.internalName) || "checkbox".equals(this.internalName)) {
            return "vertical";
        }
        return null;
    }

    public static DefaultComboBoxModel createParameterTypesModel() {
        DefaultComboBoxModel<ParameterType> model = new DefaultComboBoxModel<ParameterType>();
        model.addElement(null);
        model.addElement(new ParameterType("dropdown", Messages.getString("ParameterDialog.ParameterType.DropDown", new Object[0]), false, false));
        model.addElement(new ParameterType("list", Messages.getString("ParameterDialog.ParameterType.SingleValueList", new Object[0]), false, false));
        model.addElement(new ParameterType("list", Messages.getString("ParameterDialog.ParameterType.MultiValueList", new Object[0]), true, false));
        model.addElement(new ParameterType("radio", Messages.getString("ParameterDialog.ParameterType.RadioButton", new Object[0]), false, false));
        model.addElement(new ParameterType("checkbox", Messages.getString("ParameterDialog.ParameterType.CheckBox", new Object[0]), true, false));
        model.addElement(new ParameterType("togglebutton", Messages.getString("ParameterDialog.ParameterType.SingleSelectionButton", new Object[0]), false, false));
        model.addElement(new ParameterType("togglebutton", Messages.getString("ParameterDialog.ParameterType.MultiSelectionButton", new Object[0]), true, false));
        model.addElement(new ParameterType("textbox", Messages.getString("ParameterDialog.ParameterType.TextBox", new Object[0]), false, true));
        model.addElement(new ParameterType("multi-line", Messages.getString("ParameterDialog.ParameterType.TextArea", new Object[0]), false, true));
        model.addElement(new ParameterType("datepicker", Messages.getString("ParameterDialog.ParameterType.DatePicker", new Object[0]), false, true));
        return model;
    }
}

