/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.parameters;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.editor.ReportDataChangeListener;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.editor.ReportRenderContext;
import org.pentaho.reporting.designer.core.editor.parameters.Messages;
import org.pentaho.reporting.designer.core.editor.parameters.ParameterMappingTableModel;
import org.pentaho.reporting.designer.core.util.IconLoader;
import org.pentaho.reporting.engine.classic.core.ParameterMapping;
import org.pentaho.reporting.engine.classic.core.ReportDefinition;
import org.pentaho.reporting.engine.classic.core.Section;
import org.pentaho.reporting.libraries.designtime.swing.BorderlessButton;
import org.pentaho.reporting.libraries.designtime.swing.CommonDialog;
import org.pentaho.reporting.libraries.designtime.swing.propertyeditors.TagListTableCellEditor;

public class SubReportParameterDialog
extends CommonDialog
implements ReportDataChangeListener {
    private JTable importTable;
    private JTable exportTable;
    private TagListTableCellEditor importInnerTableCellEditor;
    private TagListTableCellEditor importOuterTableCellEditor;
    private TagListTableCellEditor exportInnerTableCellEditor;
    private TagListTableCellEditor exportOuterTableCellEditor;
    private ReportDocumentContext activeReportContext;
    private ReportDocumentContext parentReportContext;

    public SubReportParameterDialog() {
        this.init();
    }

    public SubReportParameterDialog(Dialog aParent) {
        super(aParent);
        this.init();
    }

    public SubReportParameterDialog(Frame aParent) {
        super(aParent);
        this.init();
    }

    protected void init() {
        this.setTitle(Messages.getString("SubReportParameterDialog.Title", new Object[0]));
        this.setModal(true);
        this.importInnerTableCellEditor = new TagListTableCellEditor();
        this.importOuterTableCellEditor = new TagListTableCellEditor();
        this.exportInnerTableCellEditor = new TagListTableCellEditor();
        this.exportOuterTableCellEditor = new TagListTableCellEditor();
        this.exportTable = new JTable(new ParameterMappingTableModel());
        this.exportTable.setShowHorizontalLines(true);
        this.exportTable.setShowVerticalLines(true);
        this.exportTable.setGridColor(SystemColor.controlShadow);
        this.exportTable.getColumnModel().getColumn(0).setCellEditor((TableCellEditor)this.exportOuterTableCellEditor);
        this.exportTable.getColumnModel().getColumn(1).setCellEditor((TableCellEditor)this.exportInnerTableCellEditor);
        this.exportTable.setSelectionMode(0);
        this.importTable = new JTable(new ParameterMappingTableModel());
        this.importTable.setShowHorizontalLines(true);
        this.importTable.setShowVerticalLines(true);
        this.importTable.setGridColor(SystemColor.controlShadow);
        this.importTable.getColumnModel().getColumn(0).setCellEditor((TableCellEditor)this.importOuterTableCellEditor);
        this.importTable.getColumnModel().getColumn(1).setCellEditor((TableCellEditor)this.importInnerTableCellEditor);
        this.importTable.setSelectionMode(0);
        super.init();
    }

    protected String getDialogId() {
        return "ReportDesigner.Core.SubReportParameter";
    }

    protected Component createContentPane() {
        BorderlessButton importParamAddButton = new BorderlessButton((Action)new AddParameterAction(this.importTable));
        BorderlessButton importParamRemoveButton = new BorderlessButton((Action)new RemoveParameterAction(this.importTable));
        JPanel importButtonsToolbar = new JPanel();
        importButtonsToolbar.setLayout(new FlowLayout(2));
        importButtonsToolbar.add((Component)importParamAddButton);
        importButtonsToolbar.add((Component)importParamRemoveButton);
        JPanel theImportPanel = new JPanel(new BorderLayout());
        theImportPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("SubReportParameterDialog.ImportParameter", new Object[0])));
        theImportPanel.add((Component)new JScrollPane(this.importTable), "Center");
        theImportPanel.add((Component)importButtonsToolbar, "North");
        BorderlessButton exportParamAddButton = new BorderlessButton((Action)new AddParameterAction(this.exportTable));
        BorderlessButton exportParamRemoveButton = new BorderlessButton((Action)new RemoveParameterAction(this.exportTable));
        JPanel exportButtonsToolbar = new JPanel();
        exportButtonsToolbar.setLayout(new FlowLayout(2));
        exportButtonsToolbar.add((Component)exportParamAddButton);
        exportButtonsToolbar.add((Component)exportParamRemoveButton);
        JPanel exportPanel = new JPanel(new BorderLayout());
        exportPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("SubReportParameterDialog.ExportParameter", new Object[0])));
        exportPanel.add((Component)new JScrollPane(this.exportTable), "Center");
        exportPanel.add((Component)exportButtonsToolbar, "North");
        JPanel mainPanel = new JPanel(new GridLayout(1, 2));
        mainPanel.add(theImportPanel);
        mainPanel.add(exportPanel);
        return mainPanel;
    }

    @Override
    public void dataModelChanged(ReportDocumentContext context) {
        this.configureEditors();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EditResult performEdit(ReportDesignerContext context, ParameterMapping[] importParameters, ParameterMapping[] exportParameters) {
        try {
            this.activeReportContext = context.getActiveContext();
            if (this.activeReportContext == null) {
                throw new IllegalStateException("ActiveContext should not be null when editing a report.");
            }
            this.activeReportContext.addReportDataChangeListener(this);
            this.parentReportContext = this.findParentContext(context);
            if (this.parentReportContext != null) {
                this.parentReportContext.addReportDataChangeListener(this);
            }
            this.configureEditors();
            ParameterMappingTableModel importModel = (ParameterMappingTableModel)this.importTable.getModel();
            importModel.setMappings(importParameters);
            ParameterMappingTableModel exportModel = (ParameterMappingTableModel)this.exportTable.getModel();
            exportModel.setMappings(exportParameters);
            if (!this.performEdit()) {
                EditResult editResult = null;
                return editResult;
            }
            EditResult editResult = this.saveParameters();
            return editResult;
        }
        finally {
            if (this.activeReportContext != null) {
                this.activeReportContext.removeReportDataChangeListener(this);
            }
            if (this.parentReportContext != null) {
                this.parentReportContext.removeReportDataChangeListener(this);
            }
        }
    }

    private String[] add(String value, String[] base) {
        ArrayList<String> tmp = new ArrayList<String>();
        tmp.add(value);
        tmp.addAll(Arrays.asList(base));
        return tmp.toArray(new String[tmp.size()]);
    }

    private String[] collectParentContextFields() {
        if (this.parentReportContext == null) {
            return new String[0];
        }
        return this.parentReportContext.getReportDataSchemaModel().getColumnNames();
    }

    private ReportDocumentContext findParentContext(ReportDesignerContext context) {
        ReportDocumentContext activeContext = context.getActiveContext();
        Section parentSection = activeContext.getReportDefinition().getParentSection();
        if (parentSection == null) {
            return null;
        }
        ReportDefinition parentReport = parentSection.getReportDefinition();
        if (parentReport == null) {
            return null;
        }
        int contextCount = context.getReportRenderContextCount();
        for (int i = 0; i < contextCount; ++i) {
            ReportRenderContext contextAt = context.getReportRenderContext(i);
            if (parentReport != contextAt.getReportDefinition()) continue;
            return contextAt;
        }
        return null;
    }

    private void configureEditors() {
        String[] parentNames = this.collectParentContextFields();
        this.importOuterTableCellEditor.setTags(this.add("*", parentNames));
        this.exportOuterTableCellEditor.setTags(parentNames);
        ArrayList<String> columnNames = new ArrayList<String>();
        columnNames.add("*");
        columnNames.addAll(Arrays.asList(this.activeReportContext.getReportDataSchemaModel().getColumnNames()));
        LinkedList<String> l = new LinkedList<String>(Arrays.asList(parentNames));
        l.removeAll(columnNames);
        columnNames.addAll(l);
        String[] paramList = columnNames.toArray(new String[columnNames.size()]);
        this.importInnerTableCellEditor.setTags(paramList);
        this.exportInnerTableCellEditor.setTags(paramList);
    }

    private EditResult saveParameters() {
        TableCellEditor theCellEditor = this.importTable.getCellEditor();
        if (theCellEditor != null) {
            theCellEditor.stopCellEditing();
        }
        if ((theCellEditor = this.exportTable.getCellEditor()) != null) {
            theCellEditor.stopCellEditing();
        }
        ParameterMappingTableModel importModel = (ParameterMappingTableModel)this.importTable.getModel();
        ParameterMappingTableModel exportModel = (ParameterMappingTableModel)this.exportTable.getModel();
        return new EditResult(importModel.getMappings(), exportModel.getMappings());
    }

    private static class AddParameterAction
    extends AbstractAction {
        private JTable exportTable;

        private AddParameterAction(JTable exportTable) {
            this.exportTable = exportTable;
            this.putValue("SmallIcon", IconLoader.getInstance().getAddIcon());
            this.putValue("ShortDescription", Messages.getString("SubReportParameterDialog.AddParameter", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ParameterMappingTableModel tableModel = (ParameterMappingTableModel)this.exportTable.getModel();
            tableModel.addRow();
        }
    }

    private static class RemoveParameterAction
    extends AbstractAction
    implements ListSelectionListener {
        private JTable exportTable;

        private RemoveParameterAction(JTable exportTable) {
            this.exportTable = exportTable;
            this.putValue("SmallIcon", IconLoader.getInstance().getRemoveIcon());
            this.putValue("ShortDescription", Messages.getString("SubReportParameterDialog.RemoveParameter", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int i = this.exportTable.getSelectedRow();
            if (i == -1) {
                return;
            }
            ParameterMappingTableModel tableModel = (ParameterMappingTableModel)this.exportTable.getModel();
            tableModel.removeRow(i);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.setEnabled(this.exportTable.getSelectedRow() != -1);
        }
    }

    public static class EditResult {
        private ParameterMapping[] importParameters;
        private ParameterMapping[] exportParameters;

        public EditResult(ParameterMapping[] importParameters, ParameterMapping[] exportParameters) {
            this.importParameters = (ParameterMapping[])importParameters.clone();
            this.exportParameters = (ParameterMapping[])exportParameters.clone();
        }

        public ParameterMapping[] getImportParameters() {
            return this.importParameters;
        }

        public ParameterMapping[] getExportParameters() {
            return this.exportParameters;
        }
    }
}

