/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.report;

import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import org.pentaho.reporting.designer.core.editor.report.ReportElementDragHandler;
import org.pentaho.reporting.designer.core.editor.report.ReportElementEditor;
import org.pentaho.reporting.designer.core.editor.report.ReportElementEditorContext;
import org.pentaho.reporting.designer.core.editor.report.ReportElementEditorRegistry;
import org.pentaho.reporting.designer.core.util.dnd.ElementMetaDataTransferable;
import org.pentaho.reporting.designer.core.util.dnd.FieldDescriptionTransferable;
import org.pentaho.reporting.designer.core.util.dnd.GenericDNDHandler;
import org.pentaho.reporting.engine.classic.core.metadata.ElementMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ElementType;
import org.pentaho.reporting.engine.classic.core.wizard.AutoGeneratorUtility;
import org.pentaho.reporting.engine.classic.core.wizard.ContextAwareDataSchemaModel;
import org.pentaho.reporting.engine.classic.core.wizard.DataAttributeContext;
import org.pentaho.reporting.engine.classic.core.wizard.DataAttributes;
import org.pentaho.reporting.engine.classic.core.wizard.DataSchema;
import org.pentaho.reporting.engine.classic.core.wizard.DefaultDataAttributeContext;

public class BandDndHandler
extends GenericDNDHandler {
    private ReportElementDragHandler dragHandler;
    private ReportElementEditorContext editorContext;

    public BandDndHandler(ReportElementEditorContext editorContext) {
        super(new DataFlavor[]{ElementMetaDataTransferable.ELEMENT_FLAVOR, FieldDescriptionTransferable.ELEMENT_FLAVOR});
        this.editorContext = editorContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int updateDragOver(DropTargetDragEvent event) {
        try {
            if (ElementMetaDataTransferable.ELEMENT_FLAVOR.equals(this.getFlavor())) {
                ElementMetaData data = (ElementMetaData)this.getTransferData();
                if (data == null) {
                    int n = 0;
                    return n;
                }
                if (this.dragHandler == null) {
                    this.dragHandler = this.createDragHandler(data);
                    if (this.dragHandler == null) {
                        int n = 0;
                        return n;
                    }
                    int n = this.dragHandler.dragStarted(event, this.editorContext, data, null);
                    return n;
                }
                int n = this.dragHandler.dragUpdated(event, this.editorContext, data, null);
                return n;
            }
            if (FieldDescriptionTransferable.ELEMENT_FLAVOR.equals(this.getFlavor())) {
                String fieldName = (String)this.getTransferData();
                ElementMetaData data = this.createMetaData(fieldName);
                if (data == null) {
                    int n = 0;
                    return n;
                }
                if (this.dragHandler == null) {
                    this.dragHandler = this.createDragHandler(data);
                    if (this.dragHandler == null) {
                        int n = 0;
                        return n;
                    }
                    int n = this.dragHandler.dragStarted(event, this.editorContext, data, fieldName);
                    return n;
                }
                int n = this.dragHandler.dragUpdated(event, this.editorContext, data, fieldName);
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            this.editorContext.getRepresentationContainer().revalidate();
            this.editorContext.getRepresentationContainer().repaint();
        }
    }

    private ReportElementDragHandler createDragHandler(ElementMetaData metaData) {
        if (metaData == null) {
            return null;
        }
        ReportElementEditor elementEditor = ReportElementEditorRegistry.getInstance().getPlugin(metaData.getName());
        if (elementEditor == null && (elementEditor = ReportElementEditorRegistry.getInstance().getPlugin(null)) == null) {
            return null;
        }
        return elementEditor.createDragHandler();
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
        if (this.dragHandler == null) {
            super.dragExit(dte);
            return;
        }
        this.dragHandler.dragAborted(dte, this.editorContext);
        this.dragHandler = null;
        super.dragExit(dte);
        this.editorContext.getRepresentationContainer().revalidate();
        this.editorContext.getRepresentationContainer().repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drop(DropTargetDropEvent dtde) {
        if (this.dragHandler == null) {
            dtde.rejectDrop();
            return;
        }
        try {
            if (ElementMetaDataTransferable.ELEMENT_FLAVOR.equals(this.getFlavor())) {
                ElementMetaData metaData = (ElementMetaData)this.getTransferData();
                this.dragHandler.drop(dtde, this.editorContext, metaData, null);
                return;
            }
            if (FieldDescriptionTransferable.ELEMENT_FLAVOR.equals(this.getFlavor())) {
                String fieldName = (String)this.getTransferData();
                ElementMetaData metaData = this.createMetaData(fieldName);
                this.dragHandler.drop(dtde, this.editorContext, metaData, fieldName);
                return;
            }
            dtde.rejectDrop();
        }
        finally {
            this.editorContext.getRepresentationContainer().revalidate();
            this.editorContext.getRepresentationContainer().repaint();
            this.dragHandler = null;
        }
    }

    private ElementMetaData createMetaData(String fieldName) {
        ContextAwareDataSchemaModel model = this.editorContext.getRenderContext().getReportDataSchemaModel();
        DataSchema dataSchema = model.getDataSchema();
        DataAttributes attributes = dataSchema.getAttributes(fieldName);
        DefaultDataAttributeContext dataAttributeContext = new DefaultDataAttributeContext();
        if (attributes == null) {
            return null;
        }
        ElementType type = AutoGeneratorUtility.createFieldType((DataAttributes)attributes, (DataAttributeContext)dataAttributeContext);
        if (type == null) {
            return null;
        }
        return type.getMetaData();
    }
}

