/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.report;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ImageObserver;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.editor.report.OverlayRenderer;
import org.pentaho.reporting.designer.core.model.lineal.GuideLine;
import org.pentaho.reporting.designer.core.model.lineal.LinealModel;
import org.pentaho.reporting.designer.core.settings.WorkspaceSettings;

public class GuidelineOverlayRenderer
implements OverlayRenderer {
    private double scaleFactor;
    private LinealModel verticalLinealModel;
    private LinealModel horizontalLinealModel;

    public GuidelineOverlayRenderer(LinealModel horizontalLinealModel, LinealModel verticalLinealModel) {
        this.horizontalLinealModel = horizontalLinealModel;
        this.verticalLinealModel = verticalLinealModel;
    }

    @Override
    public void validate(ReportDocumentContext context, double zoomFactor, Point2D sectionOffset) {
        this.scaleFactor = zoomFactor;
    }

    @Override
    public void draw(Graphics2D g2, Rectangle2D bounds, ImageObserver obs) {
        double linePos;
        GuideLine line;
        int i;
        g2.setStroke(new BasicStroke(0.2f));
        Color guideColor = WorkspaceSettings.getInstance().getGuideColor();
        g2.setColor(guideColor);
        if (this.verticalLinealModel != null) {
            double topBorder = bounds.getY();
            GuideLine[] vlines = this.verticalLinealModel.getGuideLines();
            int gridwidth = (int)bounds.getWidth();
            for (i = 0; i < vlines.length; ++i) {
                line = vlines[i];
                if (!line.isActive()) continue;
                double h = line.getPosition() + topBorder;
                linePos = h * this.scaleFactor;
                g2.drawLine(0, (int)linePos, gridwidth, (int)(h * this.scaleFactor));
            }
        }
        if (this.horizontalLinealModel != null) {
            double leftBorder = bounds.getX();
            GuideLine[] hlines = this.horizontalLinealModel.getGuideLines();
            int gridHeight = (int)bounds.getHeight();
            for (i = 0; i < hlines.length; ++i) {
                line = hlines[i];
                if (!line.isActive()) continue;
                double w = line.getPosition() + leftBorder;
                linePos = w * this.scaleFactor;
                g2.drawLine((int)linePos, 0, (int)linePos, gridHeight);
            }
        }
    }
}

