/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.report.layouting;

import org.pentaho.reporting.designer.core.editor.report.layouting.DesignerRenderComponentFactory;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.filter.types.bands.SubReportType;
import org.pentaho.reporting.engine.classic.core.layout.TextProducer;
import org.pentaho.reporting.engine.classic.core.layout.build.DefaultLayoutModelBuilder;
import org.pentaho.reporting.engine.classic.core.layout.model.BlockRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.context.BoxDefinition;
import org.pentaho.reporting.engine.classic.core.layout.model.context.StaticBoxLayoutProperties;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorFeature;
import org.pentaho.reporting.engine.classic.core.layout.style.SimpleStyleSheet;
import org.pentaho.reporting.engine.classic.core.layout.style.SubReportStyleSheet;
import org.pentaho.reporting.engine.classic.core.metadata.ElementType;
import org.pentaho.reporting.engine.classic.core.style.AbstractStyleSheet;
import org.pentaho.reporting.engine.classic.core.style.BandStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.StyleKey;
import org.pentaho.reporting.engine.classic.core.style.StyleSheet;
import org.pentaho.reporting.engine.classic.core.util.InstanceID;

public class DesignerLayoutModelBuilder
extends DefaultLayoutModelBuilder {
    private DesignerRenderComponentFactory renderComponentFactory;

    public DesignerLayoutModelBuilder(String legacySectionName, DesignerRenderComponentFactory renderComponentFactory) {
        super(legacySectionName);
        this.renderComponentFactory = renderComponentFactory;
    }

    protected TextProducer createTextProducer() {
        return this.renderComponentFactory.createTextProducer();
    }

    public void startSubFlow(ReportElement element) {
        RenderBox box;
        SimpleStyleSheet resolverStyleSheet = element.getComputedStyle();
        if (this.getMetaData().isFeatureSupported(OutputProcessorFeature.STRICT_COMPATIBILITY)) {
            DesignerSubReportStyleSheet styleSheet = new DesignerSubReportStyleSheet((StyleSheet)new SubReportStyleSheet(resolverStyleSheet.getBooleanStyleProperty(BandStyleKeys.PAGEBREAK_BEFORE), resolverStyleSheet.getBooleanStyleProperty(BandStyleKeys.PAGEBREAK_AFTER)));
            SimpleStyleSheet reportStyle = new SimpleStyleSheet((StyleSheet)styleSheet);
            BoxDefinition boxDefinition = this.getRenderNodeFactory().getBoxDefinition((StyleSheet)reportStyle);
            box = new BlockRenderBox((StyleSheet)reportStyle, element.getObjectID(), boxDefinition, (ElementType)SubReportType.INSTANCE, element.getAttributes(), null);
        } else {
            box = this.getRenderNodeFactory().produceRenderBox(element, (StyleSheet)new DesignerSubReportStyleSheet((StyleSheet)resolverStyleSheet), "block", this.getStateKey());
        }
        box.getStaticBoxLayoutProperties().setPlaceholderBox(StaticBoxLayoutProperties.PlaceholderType.SECTION);
        if (element.getName() != null) {
            box.setName("Banded-SubReport-Section: name=" + element.getName());
        } else {
            box.setName("Banded-SubReport-Section");
        }
        this.pushBoxToContext(box, false);
    }

    private static class DesignerSubReportStyleSheet
    extends AbstractStyleSheet {
        private StyleSheet parent;
        private Float minHeight;

        public DesignerSubReportStyleSheet(StyleSheet parent) {
            if (parent == null) {
                throw new NullPointerException();
            }
            this.parent = parent;
            float minHeightDefined = (float)parent.getDoubleStyleProperty(ElementStyleKeys.MIN_HEIGHT, 0.0);
            this.minHeight = Float.valueOf(Math.max(10.0f, minHeightDefined));
        }

        public StyleSheet getParent() {
            return this.parent;
        }

        public InstanceID getId() {
            return this.parent.getId();
        }

        public long getChangeTracker() {
            return this.parent.getChangeTracker();
        }

        public Object getStyleProperty(StyleKey key, Object defaultValue) {
            if (ElementStyleKeys.MIN_HEIGHT.equals((Object)key)) {
                return this.minHeight;
            }
            return this.parent.getStyleProperty(key, defaultValue);
        }

        public Object[] toArray() {
            Object[] objects = this.parent.toArray();
            objects[ElementStyleKeys.MIN_HEIGHT.getIdentifier()] = this.minHeight;
            return objects;
        }
    }
}

