/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.report.layouting;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.pentaho.reporting.designer.core.model.CachedLayoutData;
import org.pentaho.reporting.designer.core.model.ModelUtility;
import org.pentaho.reporting.designer.core.util.BreakPositionsList;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.RootLevelBand;
import org.pentaho.reporting.engine.classic.core.Section;
import org.pentaho.reporting.engine.classic.core.SubReport;
import org.pentaho.reporting.engine.classic.core.layout.model.LogicalPageBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderNode;
import org.pentaho.reporting.engine.classic.core.layout.model.context.BoxDefinition;
import org.pentaho.reporting.engine.classic.core.layout.process.IterateSimpleStructureProcessStep;
import org.pentaho.reporting.engine.classic.core.util.InstanceID;

public class TransferGlobalLayoutProcessStep
extends IterateSimpleStructureProcessStep {
    private Map<InstanceID, Element> elementsById;
    private long age;
    private BreakPositionsList horizontalEdgePositions = new BreakPositionsList();
    private Map<InstanceID, Set<InstanceID>> conflicts;

    public TransferGlobalLayoutProcessStep() {
        this.elementsById = new HashMap<InstanceID, Element>();
    }

    public Map<InstanceID, Element> getElementsById() {
        return this.elementsById;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performTransfer(LogicalPageBox logicalPageBox, Map<InstanceID, Set<InstanceID>> conflicts, MasterReport report) {
        this.conflicts = conflicts;
        ++this.age;
        try {
            this.elementsById.clear();
            this.elementsById.put(report.getObjectID(), (Element)report);
            this.collectDesignTimeElements((Section)report);
            this.startProcessing((RenderNode)logicalPageBox);
        }
        finally {
            this.conflicts = null;
        }
    }

    private void collectDesignTimeElements(Section sectionReportElement) {
        int count = sectionReportElement.getElementCount();
        for (int i = 0; i < count; ++i) {
            Element reportElement = sectionReportElement.getElement(i);
            InstanceID id = reportElement.getObjectID();
            this.elementsById.put(id, reportElement);
            if (!(reportElement instanceof Section)) continue;
            this.collectDesignTimeElements((Section)reportElement);
        }
        if (sectionReportElement instanceof RootLevelBand) {
            RootLevelBand rlb = (RootLevelBand)sectionReportElement;
            for (int i = 0; i < rlb.getSubReportCount(); ++i) {
                SubReport reportElement = rlb.getSubReport(i);
                InstanceID id = reportElement.getObjectID();
                this.elementsById.put(id, (Element)reportElement);
                this.collectDesignTimeElements((Section)reportElement);
            }
        }
    }

    public boolean startBox(RenderBox box) {
        InstanceID id = box.getNodeLayoutProperties().getInstanceId();
        Element element = this.elementsById.get(id);
        if (element == null) {
            return true;
        }
        CachedLayoutData data = ModelUtility.getCachedLayoutData(element);
        if (data.getLayoutAge() == this.age) {
            return true;
        }
        data.setX(box.getX());
        data.setY(box.getY());
        data.setWidth(box.getWidth());
        data.setHeight(box.getHeight());
        BoxDefinition boxDefinition = box.getBoxDefinition();
        data.setPaddingX(boxDefinition.getPaddingLeft() + boxDefinition.getBorder().getLeft().getWidth());
        data.setPaddingY(boxDefinition.getPaddingTop() + boxDefinition.getBorder().getTop().getWidth());
        data.setLayoutAge(this.age);
        data.setElementType(box.getNodeType());
        data.setConflictsInTableMode(this.conflicts.containsKey(id));
        this.horizontalEdgePositions.add(data.getX(), id);
        this.horizontalEdgePositions.add(data.getX() + data.getWidth(), id);
        return true;
    }

    public BreakPositionsList getHorizontalEdgePositions() {
        return this.horizontalEdgePositions;
    }

    public void reset() {
        this.horizontalEdgePositions.clear();
        this.elementsById.clear();
    }
}

