/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.editor.report.layouting;

import java.util.Map;
import org.pentaho.reporting.designer.core.model.CachedLayoutData;
import org.pentaho.reporting.designer.core.model.ModelUtility;
import org.pentaho.reporting.designer.core.util.BreakPositionsList;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.RootLevelBand;
import org.pentaho.reporting.engine.classic.core.Section;
import org.pentaho.reporting.engine.classic.core.SubReport;
import org.pentaho.reporting.engine.classic.core.layout.model.LogicalPageBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderNode;
import org.pentaho.reporting.engine.classic.core.layout.process.IterateSimpleStructureProcessStep;
import org.pentaho.reporting.engine.classic.core.util.InstanceID;

public class TransferLayoutProcessStep
extends IterateSimpleStructureProcessStep {
    private Map<InstanceID, Element> elementsById;
    private BreakPositionsList verticalEdgePositions;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performTransfer(Section section, LogicalPageBox logicalPageBox, Map<InstanceID, Element> elementHashMap, BreakPositionsList verticalEdgePositions) {
        this.verticalEdgePositions = verticalEdgePositions;
        this.elementsById = elementHashMap;
        try {
            this.elementsById.clear();
            this.elementsById.put(section.getObjectID(), (Element)section);
            this.collectElements(section);
            if (section instanceof RootLevelBand) {
                RootLevelBand rl = (RootLevelBand)section;
                int count = rl.getSubReportCount();
                for (int i = 0; i < count; ++i) {
                    SubReport report = rl.getSubReport(i);
                    this.elementsById.put(report.getObjectID(), (Element)report);
                }
            }
            this.startProcessing((RenderNode)logicalPageBox);
        }
        finally {
            this.elementsById = null;
            this.verticalEdgePositions = null;
        }
    }

    private void collectElements(Section sectionReportElement) {
        int count = sectionReportElement.getElementCount();
        for (int i = 0; i < count; ++i) {
            Element reportElement = sectionReportElement.getElement(i);
            InstanceID id = reportElement.getObjectID();
            this.elementsById.put(id, reportElement);
            if (reportElement instanceof SubReport || !(reportElement instanceof Section)) continue;
            this.collectElements((Section)reportElement);
        }
    }

    public boolean startBox(RenderBox box) {
        InstanceID id = box.getNodeLayoutProperties().getInstanceId();
        Element element = this.elementsById.get(id);
        if (element == null) {
            return true;
        }
        CachedLayoutData data = ModelUtility.getCachedLayoutData(element);
        this.verticalEdgePositions.add(data.getY(), id);
        this.verticalEdgePositions.add(data.getY() + data.getHeight(), id);
        return true;
    }
}

