/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.inspections;

import java.util.Timer;
import java.util.TimerTask;
import javax.swing.event.EventListenerList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.inspections.Inspection;
import org.pentaho.reporting.designer.core.inspections.InspectionResult;
import org.pentaho.reporting.designer.core.inspections.InspectionResultListener;
import org.pentaho.reporting.designer.core.inspections.InspectionRunner;
import org.pentaho.reporting.designer.core.inspections.InspectionsRegistry;
import org.pentaho.reporting.designer.core.util.exceptions.UncaughtExceptionsModel;
import org.pentaho.reporting.engine.classic.core.event.ReportModelEvent;

public class AutoInspectionRunner
implements InspectionResultListener,
InspectionRunner {
    private static final Log logger = LogFactory.getLog(AutoInspectionRunner.class);
    private final Timer timer;
    private InspectionTask lastTask;
    private ReportDocumentContext reportRenderContext;
    private EventListenerList eventListeners;

    public AutoInspectionRunner(ReportDocumentContext reportRenderContext) {
        if (reportRenderContext == null) {
            throw new NullPointerException();
        }
        this.reportRenderContext = reportRenderContext;
        this.timer = new Timer("Inspection-Manager", true);
        this.eventListeners = new EventListenerList();
        this.lastTask = new InspectionTask(new InspectionRunnable());
        this.timer.schedule((TimerTask)this.lastTask, 1000L);
    }

    public void nodeChanged(ReportModelEvent event) {
        this.startTimer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startTimer() {
        Timer timer = this.timer;
        synchronized (timer) {
            if (this.lastTask != null) {
                this.lastTask.cancel();
            }
            this.lastTask = new InspectionTask(new InspectionRunnable());
            this.timer.schedule((TimerTask)this.lastTask, 1000L);
        }
    }

    @Override
    public void dispose() {
        this.timer.cancel();
    }

    @Override
    public void notifyInspectionResult(InspectionResult result) {
        InspectionResultListener[] resultListeners = (InspectionResultListener[])this.eventListeners.getListeners(InspectionResultListener.class);
        for (int i = 0; i < resultListeners.length; ++i) {
            InspectionResultListener listener = resultListeners[i];
            listener.notifyInspectionResult(result);
        }
    }

    @Override
    public void notifyInspectionStarted() {
        InspectionResultListener[] resultListeners = (InspectionResultListener[])this.eventListeners.getListeners(InspectionResultListener.class);
        for (int i = 0; i < resultListeners.length; ++i) {
            InspectionResultListener listener = resultListeners[i];
            listener.notifyInspectionStarted();
        }
    }

    protected ReportDocumentContext getReportRenderContext() {
        return this.reportRenderContext;
    }

    @Override
    public void addInspectionListener(InspectionResultListener listener) {
        this.eventListeners.add(InspectionResultListener.class, listener);
    }

    @Override
    public void removeInspectionListener(InspectionResultListener listener) {
        this.eventListeners.remove(InspectionResultListener.class, listener);
    }

    private class InspectionRunnable
    implements Runnable {
        private InspectionRunnable() {
        }

        @Override
        public void run() {
            AutoInspectionRunner.this.notifyInspectionStarted();
            logger.debug((Object)"Inspection started");
            Inspection[] inspections = InspectionsRegistry.getInstance().getInspections();
            for (int i = 0; i < inspections.length; ++i) {
                Inspection inspection = inspections[i];
                if (!inspection.isInlineInspection()) continue;
                logger.debug((Object)("Running " + inspection));
                try {
                    inspection.inspect(null, AutoInspectionRunner.this.getReportRenderContext(), AutoInspectionRunner.this);
                    continue;
                }
                catch (Exception e) {
                    UncaughtExceptionsModel.getInstance().addException(e);
                }
            }
        }
    }

    private static class InspectionTask
    extends TimerTask {
        private Runnable runnable;

        private InspectionTask(Runnable runnable) {
            this.runnable = runnable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Runnable r = this.runnable;
            if (r == null) {
                return;
            }
            InspectionTask inspectionTask = this;
            synchronized (inspectionTask) {
                this.runnable = null;
            }
            try {
                r.run();
            }
            catch (Throwable t) {
                UncaughtExceptionsModel.getInstance().addException(t);
            }
        }

        @Override
        public synchronized boolean cancel() {
            this.runnable = null;
            return super.cancel();
        }
    }
}

