/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.inspections;

import java.awt.BorderLayout;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.inspections.InspectionResult;
import org.pentaho.reporting.designer.core.inspections.InspectionResultListener;
import org.pentaho.reporting.designer.core.inspections.InspectionResultTable;
import org.pentaho.reporting.designer.core.inspections.InspectionResultTableModel;
import org.pentaho.reporting.designer.core.inspections.LocationInfo;

public class InspectionsMessagePanel
extends JPanel {
    private InspectionResultTableModel dataModel;
    private InspectionResultTable table;
    private ReportDocumentContext reportRenderContext;

    public InspectionsMessagePanel() {
        this.setLayout(new BorderLayout());
        this.dataModel = new InspectionResultTableModel();
        this.table = new InspectionResultTable();
        this.table.setModel(this.dataModel);
        this.table.addKeyListener(new InspectionSelectionHandler());
        this.table.addMouseListener(new InspectionSelectionHandler());
        this.add(new JScrollPane(this.table));
    }

    private void performSelection(InspectionResult inspectionResult) {
        if (inspectionResult == null) {
            return;
        }
        if (this.reportRenderContext == null) {
            return;
        }
        LocationInfo[] locationInfos = inspectionResult.getLocationInfos();
        ArrayList<Object> selections = new ArrayList<Object>(locationInfos.length);
        for (int i = 0; i < locationInfos.length; ++i) {
            LocationInfo locationInfo = locationInfos[i];
            selections.add(locationInfo.getReportElement());
        }
        this.reportRenderContext.getSelectionModel().setSelectedElements(selections.toArray());
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.table.setEnabled(enabled);
    }

    public void clear() {
        this.dataModel.clear();
    }

    public InspectionResultListener getResultHandler() {
        return this.dataModel;
    }

    public ReportDocumentContext getReportRenderContext() {
        return this.reportRenderContext;
    }

    public void setReportRenderContext(ReportDocumentContext reportRenderContext) {
        this.reportRenderContext = reportRenderContext;
    }

    private class InspectionSelectionHandler
    extends MouseAdapter
    implements KeyListener {
        private InspectionSelectionHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() != 2 || e.getButton() != 1) {
                return;
            }
            int row = InspectionsMessagePanel.this.table.rowAtPoint(e.getPoint());
            if (row != -1) {
                InspectionsMessagePanel.this.performSelection(InspectionsMessagePanel.this.dataModel.getInspectionResult(row));
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
            if (e.getKeyCode() != 10) {
                return;
            }
            int selectedRow = InspectionsMessagePanel.this.table.getSelectedRow();
            if (selectedRow == -1) {
                return;
            }
            InspectionResult inspectionResult = InspectionsMessagePanel.this.dataModel.getInspectionResult(selectedRow);
            InspectionsMessagePanel.this.performSelection(inspectionResult);
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }
    }
}

