/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.inspections.impl;

import java.util.Locale;
import org.pentaho.reporting.designer.core.Messages;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.inspections.AttributeLocationInfo;
import org.pentaho.reporting.designer.core.inspections.Inspection;
import org.pentaho.reporting.designer.core.inspections.InspectionResult;
import org.pentaho.reporting.designer.core.inspections.InspectionResultListener;
import org.pentaho.reporting.designer.core.inspections.LocationInfo;
import org.pentaho.reporting.designer.core.inspections.StyleLocationInfo;
import org.pentaho.reporting.designer.core.inspections.impl.AbstractStructureInspection;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.metadata.AttributeMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.DataFactoryMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ExpressionMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.StyleMetaData;
import org.pentaho.reporting.engine.classic.core.style.StyleKey;

public class DeprecatedUsagesInspection
extends AbstractStructureInspection {
    @Override
    public boolean isInlineInspection() {
        return true;
    }

    @Override
    protected void inspectElement(ReportDesignerContext designerContext, ReportDocumentContext reportRenderContext, InspectionResultListener resultHandler, String[] columnNames, ReportElement element) {
        if (element.getMetaData().isDeprecated()) {
            String message = element.getMetaData().getDeprecationMessage(Locale.getDefault());
            resultHandler.notifyInspectionResult(new InspectionResult((Inspection)this, InspectionResult.Severity.WARNING, Messages.getString("DeprecatedUsagesInspection.ElementTypeDeprecated", element.getName(), message), new LocationInfo(element)));
        }
        this.traverseAttributeExpressions(designerContext, reportRenderContext, resultHandler, columnNames, element);
        this.traverseStyleExpressions(designerContext, reportRenderContext, resultHandler, columnNames, element);
    }

    @Override
    protected void inspectAttributeExpression(ReportDesignerContext designerContext, ReportDocumentContext reportRenderContext, InspectionResultListener resultHandler, String[] columnNames, ReportElement element, String attributeNamespace, String attributeName, Expression expression, ExpressionMetaData expressionMetaData) {
        String message;
        AttributeMetaData attrDescr = element.getMetaData().getAttributeDescription(attributeNamespace, attributeName);
        if (attrDescr != null && attrDescr.isDeprecated()) {
            message = attrDescr.getDeprecationMessage(Locale.getDefault());
            resultHandler.notifyInspectionResult(new InspectionResult((Inspection)this, InspectionResult.Severity.WARNING, Messages.getString("DeprecatedUsagesInspection.StyleExpressionTargetDeprecated", element.getName(), attrDescr.getDisplayName(Locale.getDefault()), message), new AttributeLocationInfo(element, attributeNamespace, attributeName, true)));
        }
        if (expressionMetaData == null) {
            return;
        }
        if (!expressionMetaData.isDeprecated()) {
            return;
        }
        message = expressionMetaData.getDeprecationMessage(Locale.getDefault());
        if (attrDescr != null) {
            resultHandler.notifyInspectionResult(new InspectionResult((Inspection)this, InspectionResult.Severity.WARNING, Messages.getString("DeprecatedUsagesInspection.StyleExpressionDeprecated", element.getName(), attrDescr.getDisplayName(Locale.getDefault()), message), new AttributeLocationInfo(element, attributeNamespace, attributeName, true)));
        } else {
            resultHandler.notifyInspectionResult(new InspectionResult((Inspection)this, InspectionResult.Severity.WARNING, Messages.getString("DeprecatedUsagesInspection.StyleExpressionDeprecatedNoMetaData", element.getName(), attributeNamespace, attributeName, message), new AttributeLocationInfo(element, attributeNamespace, attributeName, true)));
        }
    }

    @Override
    protected void inspectStyleExpression(ReportDesignerContext designerContext, ReportDocumentContext reportRenderContext, InspectionResultListener resultHandler, String[] columnNames, ReportElement element, StyleKey styleKey, Expression expression, ExpressionMetaData expressionMetaData) {
        String message;
        StyleMetaData styleDescription = element.getMetaData().getStyleDescription(styleKey);
        if (styleDescription != null && styleDescription.isDeprecated()) {
            message = styleDescription.getDeprecationMessage(Locale.getDefault());
            resultHandler.notifyInspectionResult(new InspectionResult((Inspection)this, InspectionResult.Severity.WARNING, Messages.getString("DeprecatedUsagesInspection.StyleExpressionTargetDeprecated", element.getName(), styleDescription.getDisplayName(Locale.getDefault()), message), new StyleLocationInfo(element, styleKey, true)));
        }
        if (expressionMetaData == null) {
            return;
        }
        if (!expressionMetaData.isDeprecated()) {
            return;
        }
        message = expressionMetaData.getDeprecationMessage(Locale.getDefault());
        if (styleDescription != null) {
            resultHandler.notifyInspectionResult(new InspectionResult((Inspection)this, InspectionResult.Severity.WARNING, Messages.getString("DeprecatedUsagesInspection.StyleExpressionDeprecated", element.getName(), styleDescription.getDisplayName(Locale.getDefault()), message), new StyleLocationInfo(element, styleKey, true)));
        } else {
            resultHandler.notifyInspectionResult(new InspectionResult((Inspection)this, InspectionResult.Severity.WARNING, Messages.getString("DeprecatedUsagesInspection.StyleExpressionDeprecatedNoMetaData", element.getName(), styleKey.getName(), message), new StyleLocationInfo(element, styleKey, true)));
        }
    }

    @Override
    protected void inspectExpression(ReportDesignerContext designerContext, ReportDocumentContext reportRenderContext, InspectionResultListener resultHandler, String[] columnNames, Expression expression, ExpressionMetaData expressionMetaData) {
        if (expressionMetaData != null && expressionMetaData.isDeprecated()) {
            String message = expressionMetaData.getDeprecationMessage(Locale.getDefault());
            resultHandler.notifyInspectionResult(new InspectionResult((Inspection)this, InspectionResult.Severity.WARNING, Messages.getString("DeprecatedUsagesInspection.ExpressionDeprecated", expression.getName(), message), new LocationInfo(expression)));
        }
    }

    @Override
    protected void inspectDataSource(ReportDesignerContext designerContext, ReportDocumentContext reportRenderContext, InspectionResultListener resultHandler, String[] columnNames, DataFactory dataFactory) {
        DataFactoryMetaData metaData = dataFactory.getMetaData();
        if (metaData.isDeprecated()) {
            String message = metaData.getDeprecationMessage(Locale.getDefault());
            resultHandler.notifyInspectionResult(new InspectionResult((Inspection)this, InspectionResult.Severity.WARNING, Messages.getString("DeprecatedUsagesInspection.DataFactoryDeprecated", metaData.getDisplayName(Locale.getDefault()), message), new LocationInfo(dataFactory)));
        }
    }
}

