/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.inspections.impl;

import java.util.Locale;
import org.pentaho.reporting.designer.core.Messages;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.inspections.AttributeLocationInfo;
import org.pentaho.reporting.designer.core.inspections.Inspection;
import org.pentaho.reporting.designer.core.inspections.InspectionResult;
import org.pentaho.reporting.designer.core.inspections.InspectionResultListener;
import org.pentaho.reporting.designer.core.inspections.LocationInfo;
import org.pentaho.reporting.designer.core.inspections.PropertyLocationInfo;
import org.pentaho.reporting.designer.core.inspections.StyleLocationInfo;
import org.pentaho.reporting.designer.core.inspections.impl.AbstractStructureInspection;
import org.pentaho.reporting.designer.core.settings.WorkspaceSettings;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.function.FormulaExpression;
import org.pentaho.reporting.engine.classic.core.metadata.AttributeMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ExpressionMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ExpressionPropertyMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.MetaData;
import org.pentaho.reporting.engine.classic.core.metadata.StyleMetaData;
import org.pentaho.reporting.engine.classic.core.style.StyleKey;
import org.pentaho.reporting.engine.classic.core.util.beans.BeanUtility;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.formula.Formula;
import org.pentaho.reporting.libraries.formula.parser.ParseException;

public class FormulaErrorInspection
extends AbstractStructureInspection {
    @Override
    public boolean isInlineInspection() {
        return true;
    }

    @Override
    protected void inspectAttributeExpression(ReportDesignerContext designerContext, ReportDocumentContext reportRenderContext, InspectionResultListener resultHandler, String[] columnNames, ReportElement element, String attributeNamespace, String attributeName, Expression expression, ExpressionMetaData expressionMetaData) {
        if (!(expression instanceof FormulaExpression)) {
            return;
        }
        FormulaExpression fe = (FormulaExpression)expression;
        String s = fe.getFormula();
        if (StringUtils.isEmpty((String)s, (boolean)true)) {
            AttributeMetaData attrMeta = element.getMetaData().getAttributeDescription(attributeNamespace, attributeName);
            if (attrMeta != null) {
                resultHandler.notifyInspectionResult(new InspectionResult((Inspection)this, InspectionResult.Severity.WARNING, Messages.getString("FormulaErrorInspection.AttributeNoFormulaNoMetaData", element.getName(), attrMeta.getDisplayName(Locale.getDefault())), new AttributeLocationInfo(element, attributeNamespace, attributeName, true)));
            } else {
                resultHandler.notifyInspectionResult(new InspectionResult((Inspection)this, InspectionResult.Severity.WARNING, Messages.getString("FormulaErrorInspection.AttributeNoFormulaNoMetaData", element.getName(), attributeNamespace, attributeName), new AttributeLocationInfo(element, attributeNamespace, attributeName, true)));
            }
            return;
        }
        try {
            this.compileFormula(s);
        }
        catch (ParseException pe) {
            AttributeMetaData attrMeta = element.getMetaData().getAttributeDescription(attributeNamespace, attributeName);
            if (attrMeta != null) {
                resultHandler.notifyInspectionResult(new InspectionResult((Inspection)this, InspectionResult.Severity.WARNING, Messages.getString("FormulaErrorInspection.AttributeInvalidFormula", element.getName(), attrMeta.getDisplayName(Locale.getDefault())), new AttributeLocationInfo(element, attributeNamespace, attributeName, true)));
            }
            resultHandler.notifyInspectionResult(new InspectionResult((Inspection)this, InspectionResult.Severity.WARNING, Messages.getString("FormulaErrorInspection.AttributeInvalidFormulaNoMetaData", element.getName(), attributeNamespace, attributeName), new AttributeLocationInfo(element, attributeNamespace, attributeName, true)));
        }
    }

    @Override
    protected void inspectStyleExpression(ReportDesignerContext designerContext, ReportDocumentContext reportRenderContext, InspectionResultListener resultHandler, String[] columnNames, ReportElement element, StyleKey styleKey, Expression expression, ExpressionMetaData expressionMetaData) {
        if (!(expression instanceof FormulaExpression)) {
            return;
        }
        FormulaExpression fe = (FormulaExpression)expression;
        String s = fe.getFormula();
        if (StringUtils.isEmpty((String)s, (boolean)true)) {
            StyleMetaData description = element.getMetaData().getStyleDescription(styleKey);
            if (description == null) {
                resultHandler.notifyInspectionResult(new InspectionResult((Inspection)this, InspectionResult.Severity.WARNING, Messages.getString("FormulaErrorInspection.StyleNoFormulaNoMetaData", element.getName(), styleKey.getName()), new StyleLocationInfo(element, styleKey, true)));
            } else {
                resultHandler.notifyInspectionResult(new InspectionResult((Inspection)this, InspectionResult.Severity.WARNING, Messages.getString("FormulaErrorInspection.StyleNoFormula", element.getName(), description.getDisplayName(Locale.getDefault())), new StyleLocationInfo(element, styleKey, true)));
            }
            return;
        }
        try {
            this.compileFormula(s);
        }
        catch (ParseException pe) {
            StyleMetaData description = element.getMetaData().getStyleDescription(styleKey);
            if (description != null) {
                resultHandler.notifyInspectionResult(new InspectionResult((Inspection)this, InspectionResult.Severity.WARNING, Messages.getString("FormulaErrorInspection.StyleInvalidFormula", element.getName(), description.getDisplayName(Locale.getDefault())), new StyleLocationInfo(element, styleKey, true)));
            }
            resultHandler.notifyInspectionResult(new InspectionResult((Inspection)this, InspectionResult.Severity.WARNING, Messages.getString("FormulaErrorInspection.StyleInvalidFormulaNoMetaData", element.getName(), styleKey.getName()), new StyleLocationInfo(element, styleKey, true)));
        }
    }

    @Override
    protected void inspectElement(ReportDesignerContext designerContext, ReportDocumentContext reportRenderContext, InspectionResultListener resultHandler, String[] columnNames, ReportElement element) {
        this.traverseAttributeExpressions(designerContext, reportRenderContext, resultHandler, columnNames, element);
        this.traverseStyleExpressions(designerContext, reportRenderContext, resultHandler, columnNames, element);
    }

    private Formula compileFormula(String formula) throws ParseException {
        int separator;
        if (formula == null) {
            throw new ParseException("Formula is invalid");
        }
        String formulaExpression = formula.length() > 0 && formula.charAt(0) == '=' ? formula.substring(1) : ((separator = formula.indexOf(58)) <= 0 || separator + 1 == formula.length() ? null : formula.substring(separator + 1));
        if (formulaExpression == null) {
            throw new ParseException("Formula is invalid");
        }
        return new Formula(formulaExpression);
    }

    @Override
    protected void inspectExpression(ReportDesignerContext designerContext, ReportDocumentContext reportRenderContext, InspectionResultListener resultHandler, String[] columnNames, Expression expression, ExpressionMetaData expressionMetaData) {
        if (expressionMetaData == null) {
            return;
        }
        try {
            BeanUtility utility = new BeanUtility((Object)expression);
            ExpressionPropertyMetaData[] datas = expressionMetaData.getPropertyDescriptions();
            for (int i = 0; i < datas.length; ++i) {
                Object o;
                ExpressionPropertyMetaData metaData = datas[i];
                if (metaData.isHidden() || !WorkspaceSettings.getInstance().isVisible((MetaData)metaData) || !"Formula".equals(metaData.getPropertyRole()) || !((o = utility.getProperty(metaData.getName())) instanceof String)) continue;
                try {
                    this.compileFormula((String)o);
                    continue;
                }
                catch (ParseException fpe) {
                    resultHandler.notifyInspectionResult(new InspectionResult((Inspection)this, InspectionResult.Severity.WARNING, Messages.getString("FormulaErrorInspection.ExpressionInvalidFormula", expression.getName(), metaData.getDisplayName(Locale.getDefault())), new PropertyLocationInfo(expression, metaData.getName())));
                }
            }
        }
        catch (Exception e) {
            resultHandler.notifyInspectionResult(new InspectionResult((Inspection)this, InspectionResult.Severity.WARNING, e.getMessage(), new LocationInfo(expression)));
        }
    }
}

