/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.inspections.impl;

import java.text.DecimalFormat;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Locale;
import org.pentaho.reporting.designer.core.Messages;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.inspections.AttributeExpressionPropertyLocationInfo;
import org.pentaho.reporting.designer.core.inspections.AttributeLocationInfo;
import org.pentaho.reporting.designer.core.inspections.Inspection;
import org.pentaho.reporting.designer.core.inspections.InspectionResult;
import org.pentaho.reporting.designer.core.inspections.InspectionResultListener;
import org.pentaho.reporting.designer.core.inspections.LocationInfo;
import org.pentaho.reporting.designer.core.inspections.PropertyLocationInfo;
import org.pentaho.reporting.designer.core.inspections.StyleExpressionPropertyLocationInfo;
import org.pentaho.reporting.designer.core.inspections.impl.AbstractStructureInspection;
import org.pentaho.reporting.designer.core.util.exceptions.UncaughtExceptionsModel;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.filter.MessageFormatSupport;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.metadata.AttributeMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ExpressionMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ExpressionPropertyMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.StyleMetaData;
import org.pentaho.reporting.engine.classic.core.style.StyleKey;
import org.pentaho.reporting.engine.classic.core.util.beans.BeanUtility;

public class InvalidFormatInspection
extends AbstractStructureInspection {
    @Override
    public boolean isInlineInspection() {
        return true;
    }

    @Override
    protected void inspectElement(ReportDesignerContext designerContext, ReportDocumentContext reportRenderContext, InspectionResultListener resultHandler, String[] columnNames, ReportElement element) {
        AttributeMetaData[] datas = element.getMetaData().getAttributeDescriptions();
        for (int i = 0; i < datas.length; ++i) {
            AttributeMetaData data = datas[i];
            Object value = element.getAttribute(data.getNameSpace(), data.getName());
            if (!(value instanceof String)) continue;
            String fmtString = (String)value;
            String role = data.getValueRole();
            try {
                Format fmt;
                if ("NumberFormat".equals(role)) {
                    fmt = new DecimalFormat(fmtString);
                    continue;
                }
                if ("DateFormat".equals(role)) {
                    fmt = new SimpleDateFormat(fmtString);
                    continue;
                }
                if (!"Message".equals(role)) continue;
                MessageFormatSupport support = new MessageFormatSupport();
                support.setFormatString(fmtString);
                continue;
            }
            catch (Exception e) {
                resultHandler.notifyInspectionResult(new InspectionResult((Inspection)this, InspectionResult.Severity.WARNING, Messages.getString("InvalidFormatInspection.AttributeInvalidFormat", element.getName(), data.getDisplayName(Locale.getDefault()), fmtString), new AttributeLocationInfo(element, data.getNameSpace(), data.getName(), false)));
            }
        }
        this.traverseAttributeExpressions(designerContext, reportRenderContext, resultHandler, columnNames, element);
        this.traverseStyleExpressions(designerContext, reportRenderContext, resultHandler, columnNames, element);
    }

    @Override
    protected void inspectAttributeExpression(ReportDesignerContext designerContext, ReportDocumentContext reportRenderContext, InspectionResultListener resultHandler, String[] columnNames, ReportElement element, String attributeNamespace, String attributeName, Expression expression, ExpressionMetaData expressionMetaData) {
        try {
            BeanUtility utility = new BeanUtility((Object)expression);
            ExpressionPropertyMetaData[] propertyDescriptions = expressionMetaData.getPropertyDescriptions();
            for (int x = 0; x < propertyDescriptions.length; ++x) {
                ExpressionPropertyMetaData metaData = propertyDescriptions[x];
                Object o = utility.getProperty(metaData.getName());
                if (!(o instanceof String)) continue;
                String fmtString = (String)o;
                String role = metaData.getPropertyRole();
                try {
                    Format fmt;
                    if ("NumberFormat".equals(role)) {
                        fmt = new DecimalFormat(String.valueOf(o));
                        continue;
                    }
                    if ("DateFormat".equals(role)) {
                        fmt = new SimpleDateFormat(String.valueOf(o));
                        continue;
                    }
                    if (!"Message".equals(role)) continue;
                    MessageFormatSupport support = new MessageFormatSupport();
                    support.setFormatString(fmtString);
                    continue;
                }
                catch (Exception e) {
                    AttributeMetaData attrMetaData = element.getMetaData().getAttributeDescription(attributeNamespace, attributeName);
                    if (attrMetaData == null) {
                        resultHandler.notifyInspectionResult(new InspectionResult((Inspection)this, InspectionResult.Severity.WARNING, Messages.getString("InvalidFormatInspection.AttributeExpressionInvalidFormatNoMetaData", element.getName(), attributeNamespace, attributeName, fmtString, metaData.getDisplayName(Locale.getDefault())), new AttributeExpressionPropertyLocationInfo(element, attributeNamespace, attributeName, metaData.getName())));
                        continue;
                    }
                    resultHandler.notifyInspectionResult(new InspectionResult((Inspection)this, InspectionResult.Severity.WARNING, Messages.getString("InvalidFormatInspection.AttributeExpressionInvalidFormat", element.getName(), attrMetaData.getDisplayName(Locale.getDefault()), fmtString, metaData.getDisplayName(Locale.getDefault())), new AttributeExpressionPropertyLocationInfo(element, attributeNamespace, attributeName, metaData.getName())));
                }
            }
        }
        catch (Exception e) {
            UncaughtExceptionsModel.getInstance().addException(e);
        }
    }

    @Override
    protected void inspectStyleExpression(ReportDesignerContext designerContext, ReportDocumentContext reportRenderContext, InspectionResultListener resultHandler, String[] columnNames, ReportElement element, StyleKey styleKey, Expression expression, ExpressionMetaData expressionMetaData) {
        if (expressionMetaData == null) {
            return;
        }
        try {
            BeanUtility utility = new BeanUtility((Object)expression);
            ExpressionPropertyMetaData[] propertyDescriptions = expressionMetaData.getPropertyDescriptions();
            for (int x = 0; x < propertyDescriptions.length; ++x) {
                ExpressionPropertyMetaData metaData = propertyDescriptions[x];
                Object o = utility.getProperty(metaData.getName());
                if (!(o instanceof String)) continue;
                String fmtString = (String)o;
                String role = metaData.getPropertyRole();
                try {
                    Format fmt;
                    if ("NumberFormat".equals(role)) {
                        fmt = new DecimalFormat(String.valueOf(o));
                        continue;
                    }
                    if ("DateFormat".equals(role)) {
                        fmt = new SimpleDateFormat(String.valueOf(o));
                        continue;
                    }
                    if (!"Message".equals(role)) continue;
                    MessageFormatSupport support = new MessageFormatSupport();
                    support.setFormatString(fmtString);
                    continue;
                }
                catch (Exception e) {
                    StyleMetaData attrMetaData = element.getMetaData().getStyleDescription(styleKey);
                    resultHandler.notifyInspectionResult(new InspectionResult((Inspection)this, InspectionResult.Severity.WARNING, Messages.getString("InvalidFormatInspection.StyleExpressionInvalidFormat", element.getName(), attrMetaData.getDisplayName(Locale.getDefault()), fmtString, metaData.getDisplayName(Locale.getDefault())), new StyleExpressionPropertyLocationInfo(element, styleKey, metaData.getName())));
                }
            }
        }
        catch (Exception e) {
            UncaughtExceptionsModel.getInstance().addException(e);
        }
    }

    @Override
    protected void inspectExpression(ReportDesignerContext designerContext, ReportDocumentContext reportRenderContext, InspectionResultListener resultHandler, String[] columnNames, Expression expression, ExpressionMetaData expressionMetaData) {
        if (expressionMetaData == null) {
            return;
        }
        try {
            BeanUtility utility = new BeanUtility((Object)expression);
            ExpressionPropertyMetaData[] datas = expressionMetaData.getPropertyDescriptions();
            for (int i = 0; i < datas.length; ++i) {
                ExpressionPropertyMetaData metaData = datas[i];
                Object o = utility.getProperty(metaData.getName());
                if (!(o instanceof String)) continue;
                String fmtString = (String)o;
                String role = metaData.getPropertyRole();
                try {
                    Format fmt;
                    if ("NumberFormat".equals(role)) {
                        fmt = new DecimalFormat(String.valueOf(o));
                        continue;
                    }
                    if ("DateFormat".equals(role)) {
                        fmt = new SimpleDateFormat(String.valueOf(o));
                        continue;
                    }
                    if (!"Message".equals(role)) continue;
                    MessageFormatSupport support = new MessageFormatSupport();
                    support.setFormatString(fmtString);
                    continue;
                }
                catch (Exception e) {
                    resultHandler.notifyInspectionResult(new InspectionResult((Inspection)this, InspectionResult.Severity.WARNING, Messages.getString("InvalidFormatInspection.ExpressionInvalidFormat", expression.getName(), metaData.getDisplayName(Locale.getDefault()), fmtString, metaData.getDisplayName(Locale.getDefault())), new PropertyLocationInfo(expression, metaData.getName())));
                }
            }
        }
        catch (Exception e) {
            resultHandler.notifyInspectionResult(new InspectionResult((Inspection)this, InspectionResult.Severity.WARNING, e.getMessage(), new LocationInfo(expression)));
        }
    }
}

