/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.settings;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.event.EventListenerList;
import org.pentaho.reporting.designer.core.model.ModelUtility;
import org.pentaho.reporting.designer.core.settings.SettingsListener;
import org.pentaho.reporting.designer.core.util.exceptions.UncaughtExceptionsModel;

public class DateFormatModel {
    private EventListenerList eventListeners = new EventListenerList();
    private Preferences properties = Preferences.userRoot().node("org/pentaho/reporting/designer/dateformats");
    private static final String[] EMPTY_FORMATS = new String[0];

    public void addSettingsListener(SettingsListener listener) {
        this.eventListeners.add(SettingsListener.class, listener);
    }

    public void removeSettingsListener(SettingsListener listener) {
        this.eventListeners.remove(SettingsListener.class, listener);
    }

    public String[] getNumberFormats() {
        try {
            ArrayList<String> retval = this.getFormatsAsList();
            if (!retval.isEmpty()) {
                return retval.toArray(new String[retval.size()]);
            }
            return ModelUtility.getDateFormats();
        }
        catch (BackingStoreException e) {
            UncaughtExceptionsModel.getInstance().addException(e);
            return EMPTY_FORMATS;
        }
    }

    private ArrayList<String> getFormatsAsList() throws BackingStoreException {
        ArrayList<String> retval = new ArrayList<String>();
        Object[] strings = this.properties.keys();
        Arrays.sort(strings);
        int maxFiles = Math.min(10, strings.length);
        for (int i = 0; i < maxFiles; ++i) {
            Object key = strings[i];
            String file = this.properties.get((String)key, null);
            retval.add(file);
        }
        if (retval.size() != strings.length) {
            this.store(retval);
        }
        return retval;
    }

    private void store(List<String> files) throws BackingStoreException {
        this.properties.clear();
        for (int i = 0; i < files.size(); ++i) {
            String file = files.get(i);
            this.properties.put(String.valueOf(i), file);
        }
        this.properties.flush();
    }

    public void setNumberFormats(String[] file) {
        try {
            this.store(Arrays.asList(file));
        }
        catch (BackingStoreException e) {
            UncaughtExceptionsModel.getInstance().addException(e);
        }
        this.fireSettingsChanged();
    }

    private void fireSettingsChanged() {
        SettingsListener[] listeners = (SettingsListener[])this.eventListeners.getListeners(SettingsListener.class);
        for (int i = 0; i < listeners.length; ++i) {
            SettingsListener listener = listeners[i];
            listener.settingsChanged();
        }
    }

    public void clear() {
        try {
            this.properties.clear();
            this.fireSettingsChanged();
        }
        catch (BackingStoreException e) {
            UncaughtExceptionsModel.getInstance().addException(e);
        }
    }
}

